/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class GlobalActionKey
extends AbstractMessageKey {
    private static final String EMPTY_PARTITION_KEY = "__apicurio_registry_global_action__";

    public static GlobalActionKey create(String tenantId) {
        GlobalActionKey key = new GlobalActionKey();
        key.setTenantId(tenantId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.GlobalAction;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + EMPTY_PARTITION_KEY;
    }

    @Override
    public String toString() {
        return String.format("GlobalKey(super = %s)", super.toString());
    }
}

