/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.UUID;

@RegisterForReflection
public class GlobalIdKey
extends AbstractMessageKey {
    private static final String GLOBAL_ID_PARTITION_KEY = "__apicurio_registry_global_id__";
    private final String uuid = UUID.randomUUID().toString();

    public static final GlobalIdKey create(String tenantId) {
        GlobalIdKey key = new GlobalIdKey();
        key.setTenantId(tenantId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.GlobalId;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + GLOBAL_ID_PARTITION_KEY;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String toString() {
        return String.format("GlobalIdKey(super = %s)", super.toString());
    }
}

