/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.apicurio.registry.types.RuleType;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class GlobalRuleKey
extends AbstractMessageKey {
    private static final String GLOBAL_RULE_PARTITION_KEY = "__apicurio_registry_global_rule__";
    private RuleType ruleType;

    public static final GlobalRuleKey create(String tenantId, RuleType ruleType) {
        GlobalRuleKey key = new GlobalRuleKey();
        key.setTenantId(tenantId);
        key.setRuleType(ruleType);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.GlobalRule;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + GLOBAL_RULE_PARTITION_KEY;
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(RuleType ruleType) {
        this.ruleType = ruleType;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ruleType=" + this.getRuleType() + "]";
    }
}

