/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class GroupKey
extends AbstractMessageKey {
    private String groupId;

    public static final GroupKey create(String tenantId, String groupId) {
        GroupKey key = new GroupKey();
        key.setTenantId(tenantId);
        key.setGroupId(groupId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.Group;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + "/" + this.groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public String toString() {
        return "GroupKey [groupId=" + this.groupId + "]";
    }
}

