/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactOwnerKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactRuleKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactVersionKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.BootstrapKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.CommentIdKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.CommentKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ConfigPropertyKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ContentIdKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ContentKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.DownloadKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GlobalActionKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GlobalIdKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GlobalRuleKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GroupKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.LogConfigKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.MessageKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.RoleMappingKey;
import java.util.HashMap;
import java.util.Map;

public class MessageTypeToKeyClass {
    private static final MessageType[] types = MessageType.values();
    private static final Map<MessageType, Class<? extends MessageKey>> index = new HashMap<MessageType, Class<? extends MessageKey>>();

    public static final Class<? extends MessageKey> typeToKey(MessageType type) {
        return index.get((Object)type);
    }

    public static final Class<? extends MessageKey> ordToKeyClass(byte typeOrdinal) {
        MessageType type = MessageType.fromOrd(typeOrdinal);
        return MessageTypeToKeyClass.typeToKey(type);
    }

    static {
        block19: for (MessageType type : types) {
            switch (type) {
                case Bootstrap: {
                    index.put(type, BootstrapKey.class);
                    continue block19;
                }
                case Group: {
                    index.put(type, GroupKey.class);
                    continue block19;
                }
                case Artifact: {
                    index.put(type, ArtifactKey.class);
                    continue block19;
                }
                case ArtifactRule: {
                    index.put(type, ArtifactRuleKey.class);
                    continue block19;
                }
                case Content: {
                    index.put(type, ContentKey.class);
                    continue block19;
                }
                case GlobalRule: {
                    index.put(type, GlobalRuleKey.class);
                    continue block19;
                }
                case LogConfig: {
                    index.put(type, LogConfigKey.class);
                    continue block19;
                }
                case ArtifactVersion: {
                    index.put(type, ArtifactVersionKey.class);
                    continue block19;
                }
                case GlobalId: {
                    index.put(type, GlobalIdKey.class);
                    continue block19;
                }
                case ContentId: {
                    index.put(type, ContentIdKey.class);
                    continue block19;
                }
                case RoleMapping: {
                    index.put(type, RoleMappingKey.class);
                    continue block19;
                }
                case GlobalAction: {
                    index.put(type, GlobalActionKey.class);
                    continue block19;
                }
                case Download: {
                    index.put(type, DownloadKey.class);
                    continue block19;
                }
                case ConfigProperty: {
                    index.put(type, ConfigPropertyKey.class);
                    continue block19;
                }
                case ArtifactOwner: {
                    index.put(type, ArtifactOwnerKey.class);
                    continue block19;
                }
                case CommentId: {
                    index.put(type, CommentIdKey.class);
                    continue block19;
                }
                case Comment: {
                    index.put(type, CommentKey.class);
                    continue block19;
                }
                default: {
                    throw new RuntimeException("[MessageTypeToKeyClass] Type not mapped: " + type);
                }
            }
        }
    }
}

