/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.keys;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.AbstractMessageKey;
import io.quarkus.runtime.annotations.RegisterForReflection;

@RegisterForReflection
public class RoleMappingKey
extends AbstractMessageKey {
    private static final String ROLE_MAPPING_PARTITION_KEY = "__apicurio_registry_role_mapping__";
    private String principalId;

    public static final RoleMappingKey create(String tenantId, String principalId) {
        RoleMappingKey key = new RoleMappingKey();
        key.setTenantId(tenantId);
        key.setString(principalId);
        return key;
    }

    @Override
    public MessageType getType() {
        return MessageType.RoleMapping;
    }

    @Override
    public String getPartitionKey() {
        return this.getTenantId() + ROLE_MAPPING_PARTITION_KEY;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public void setString(String principalId) {
        this.principalId = principalId;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[principalId=" + this.getPrincipalId() + "]";
    }
}

