/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.serde;

import java.util.HashMap;
import java.util.Map;

public class ArtifactTypeOrdUtil {
    private static final Map<String, Byte> atToOrd = new HashMap<String, Byte>();
    private static final Map<Byte, String> ordToAt = new HashMap<Byte, String>();

    public static byte artifactTypeToOrd(String artifactType) {
        if (artifactType == null) {
            return 0;
        }
        return atToOrd.get(artifactType);
    }

    public static String ordToArtifactType(byte ord) {
        if (ord == 0) {
            return null;
        }
        return ordToAt.get(ord);
    }

    private static void index(String artifactType, int ord) {
        ordToAt.put((byte)ord, artifactType);
        atToOrd.put(artifactType, (byte)ord);
    }

    static {
        ArtifactTypeOrdUtil.index("ASYNCAPI", 1);
        ArtifactTypeOrdUtil.index("AVRO", 2);
        ArtifactTypeOrdUtil.index("GRAPHQL", 3);
        ArtifactTypeOrdUtil.index("JSON", 4);
        ArtifactTypeOrdUtil.index("KCONNECT", 5);
        ArtifactTypeOrdUtil.index("OPENAPI", 6);
        ArtifactTypeOrdUtil.index("PROTOBUF", 7);
        ArtifactTypeOrdUtil.index("WSDL", 9);
        ArtifactTypeOrdUtil.index("XML", 10);
        ArtifactTypeOrdUtil.index("XSD", 11);
    }
}

