/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.serde;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.values.ActionType;
import io.apicurio.registry.storage.impl.kafkasql.values.ContentValue;
import io.apicurio.registry.storage.impl.kafkasql.values.MessageTypeToValueClass;
import io.apicurio.registry.storage.impl.kafkasql.values.MessageValue;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSqlValueDeserializer
implements Deserializer<MessageValue> {
    private static final Logger log = LoggerFactory.getLogger(KafkaSqlValueDeserializer.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public MessageValue deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            byte msgTypeOrdinal = data[0];
            if (msgTypeOrdinal == MessageType.Content.getOrd()) {
                return this.deserializeContent(topic, data);
            }
            Class<? extends MessageValue> keyClass = MessageTypeToValueClass.ordToValue(msgTypeOrdinal);
            UnsynchronizedByteArrayInputStream in = new UnsynchronizedByteArrayInputStream(data, 1);
            MessageValue key = (MessageValue)mapper.readValue((InputStream)in, keyClass);
            return key;
        }
        catch (Exception e) {
            log.error("Error deserializing a Kafka+SQL message (value).", (Throwable)e);
            return null;
        }
    }

    private ContentValue deserializeContent(String topic, byte[] data) {
        int referencesLen;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        byteBuffer.get();
        byte actionOrdinal = byteBuffer.get();
        String canonicalHash = null;
        int hashLen = byteBuffer.getInt();
        if (hashLen > 0) {
            byte[] bytes = new byte[hashLen];
            byteBuffer.get(bytes);
            canonicalHash = new String(bytes, StandardCharsets.UTF_8);
        }
        ContentHandle contentHandle = null;
        int numContentBytes = byteBuffer.getInt();
        if (numContentBytes > 0) {
            byte[] contentBytes = new byte[numContentBytes];
            byteBuffer.get(contentBytes);
            contentHandle = ContentHandle.create((byte[])contentBytes);
        }
        String serializedReferences = null;
        if (byteBuffer.hasRemaining() && (referencesLen = byteBuffer.getInt()) > 0) {
            byte[] bytes = new byte[referencesLen];
            byteBuffer.get(bytes);
            serializedReferences = new String(bytes, StandardCharsets.UTF_8);
        }
        ActionType action = ActionType.fromOrd(actionOrdinal);
        return ContentValue.create(action, canonicalHash, contentHandle, serializedReferences);
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, true);
    }
}

