/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.serde;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.values.ContentValue;
import io.apicurio.registry.storage.impl.kafkasql.values.MessageValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaSqlValueSerializer
implements Serializer<MessageValue> {
    private static final ObjectMapper mapper = new ObjectMapper();

    public byte[] serialize(String topic, MessageValue messageValue) {
        byte[] byArray;
        if (messageValue == null) {
            return null;
        }
        if (messageValue.getType() == MessageType.Content) {
            return this.serializeContent(topic, (ContentValue)messageValue);
        }
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
        try {
            out.write(ByteBuffer.allocate(1).put(messageValue.getType().getOrd()).array());
            mapper.writeValue((OutputStream)out, (Object)messageValue);
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        out.close();
        return byArray;
    }

    private byte[] serializeContent(String topic, ContentValue contentValue) {
        byte[] byArray;
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
        try {
            byte[] bytes;
            out.write(ByteBuffer.allocate(1).put(contentValue.getType().getOrd()).array());
            out.write(ByteBuffer.allocate(1).put(contentValue.getAction().getOrd()).array());
            if (contentValue.getCanonicalHash() != null) {
                bytes = contentValue.getCanonicalHash().getBytes(StandardCharsets.UTF_8);
                out.write(ByteBuffer.allocate(4).putInt(bytes.length).array());
                out.write(ByteBuffer.allocate(bytes.length).put(bytes).array());
            } else {
                out.write(ByteBuffer.allocate(4).putInt(0).array());
            }
            if (contentValue.getContent() != null) {
                byte[] contentBytes = contentValue.getContent().bytes();
                out.write(ByteBuffer.allocate(4).putInt(contentBytes.length).array());
                out.write(contentBytes);
            } else {
                out.write(ByteBuffer.allocate(4).putInt(0).array());
            }
            if (null != contentValue.getSerializedReferences()) {
                bytes = contentValue.getSerializedReferences().getBytes(StandardCharsets.UTF_8);
                out.write(ByteBuffer.allocate(4).putInt(bytes.length).array());
                out.write(ByteBuffer.allocate(bytes.length).put(bytes).array());
            } else {
                out.write(ByteBuffer.allocate(4).putInt(0).array());
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        out.close();
        return byArray;
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

