/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.sql;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.multitenancy.ApicurioTenantContext;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.common.apps.multitenancy.TenantContextLoader;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.dto.ArtifactOwnerDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlCoordinator;
import io.apicurio.registry.storage.impl.kafkasql.KafkaSqlSubmitter;
import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactOwnerKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactRuleKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ArtifactVersionKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.CommentIdKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.CommentKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ConfigPropertyKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ContentIdKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.ContentKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.DownloadKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GlobalActionKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GlobalIdKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GlobalRuleKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.GroupKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.LogConfigKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.MessageKey;
import io.apicurio.registry.storage.impl.kafkasql.keys.RoleMappingKey;
import io.apicurio.registry.storage.impl.kafkasql.sql.KafkaSqlStore;
import io.apicurio.registry.storage.impl.kafkasql.values.AbstractMessageValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactOwnerValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactRuleValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactVersionValue;
import io.apicurio.registry.storage.impl.kafkasql.values.CommentIdValue;
import io.apicurio.registry.storage.impl.kafkasql.values.CommentValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ConfigPropertyValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ContentIdValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ContentValue;
import io.apicurio.registry.storage.impl.kafkasql.values.DownloadValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GlobalActionValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GlobalIdValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GlobalRuleValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GroupValue;
import io.apicurio.registry.storage.impl.kafkasql.values.LogConfigValue;
import io.apicurio.registry.storage.impl.kafkasql.values.MessageValue;
import io.apicurio.registry.storage.impl.kafkasql.values.RoleMappingValue;
import io.apicurio.registry.storage.impl.sql.IdGenerator;
import io.apicurio.registry.storage.impl.sql.jdb.Handle;
import io.apicurio.registry.types.RegistryException;
import io.apicurio.registry.utils.impexp.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.CommentEntity;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.apicurio.registry.utils.impexp.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.GroupEntity;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;

@ApplicationScoped
@Logged
public class KafkaSqlSink {
    @Inject
    Logger log;
    @Inject
    KafkaSqlCoordinator coordinator;
    @Inject
    KafkaSqlStore sqlStore;
    @Inject
    KafkaSqlSubmitter submitter;
    @Inject
    TenantContext tenantContext;
    @Inject
    TenantContextLoader tcl;

    @ActivateRequestContext
    public void processMessage(ConsumerRecord<MessageKey, MessageValue> record) {
        UUID requestId = this.extractUuid(record);
        this.log.debug("Processing Kafka message with UUID: {}", (Object)requestId);
        try {
            Object result = this.doProcessMessage(record);
            this.log.trace("Processed message key: {} value: {} result: {}", new Object[]{((MessageKey)record.key()).getType().name(), record.value() != null ? ((MessageValue)record.value()).toString() : "", result != null ? result.toString() : ""});
            this.log.debug("Kafka message successfully processed. Notifying listeners of response.");
            this.coordinator.notifyResponse(requestId, result);
        }
        catch (RegistryException e) {
            this.log.debug("Registry exception detected: {}", (Object)e.getMessage());
            this.coordinator.notifyResponse(requestId, (Object)e);
        }
        catch (Throwable e) {
            this.log.debug("Unexpected exception detected: {}", (Object)e.getMessage());
            this.coordinator.notifyResponse(requestId, (Object)new RegistryException(e));
        }
    }

    private UUID extractUuid(ConsumerRecord<MessageKey, MessageValue> record) {
        return Optional.ofNullable(record.headers().headers("req")).map(Iterable::iterator).map(it -> it.hasNext() ? (Header)it.next() : null).map(Header::value).map(String::new).map(UUID::fromString).orElse(null);
    }

    private Object doProcessMessage(ConsumerRecord<MessageKey, MessageValue> record) {
        MessageKey key = (MessageKey)record.key();
        MessageValue value = (MessageValue)record.value();
        String tenantId = key.getTenantId();
        if (tenantId != null) {
            ApicurioTenantContext tctx = this.tcl.loadBatchJobContext(tenantId);
            this.tenantContext.setContext(tctx);
        }
        try {
            MessageType messageType = key.getType();
            switch (messageType) {
                case Group: {
                    Object object = this.processGroupMessage((GroupKey)key, (GroupValue)value);
                    return object;
                }
                case Artifact: {
                    Object object = this.processArtifactMessage((ArtifactKey)key, (ArtifactValue)value);
                    return object;
                }
                case ArtifactRule: {
                    Object object = this.processArtifactRuleMessage((ArtifactRuleKey)key, (ArtifactRuleValue)value);
                    return object;
                }
                case ArtifactVersion: {
                    Object object = this.processArtifactVersion((ArtifactVersionKey)key, (ArtifactVersionValue)value);
                    return object;
                }
                case Content: {
                    Object object = this.processContent((ContentKey)key, (ContentValue)value);
                    return object;
                }
                case GlobalRule: {
                    Object object = this.processGlobalRule((GlobalRuleKey)key, (GlobalRuleValue)value);
                    return object;
                }
                case GlobalId: {
                    Object object = this.processGlobalId((GlobalIdKey)key, (GlobalIdValue)value);
                    return object;
                }
                case ContentId: {
                    Object object = this.processContentId((ContentIdKey)key, (ContentIdValue)value);
                    return object;
                }
                case LogConfig: {
                    Object object = this.processLogConfig((LogConfigKey)key, (LogConfigValue)value);
                    return object;
                }
                case RoleMapping: {
                    Object object = this.processRoleMapping((RoleMappingKey)key, (RoleMappingValue)value);
                    return object;
                }
                case GlobalAction: {
                    Object object = this.processGlobalAction((GlobalActionKey)key, (GlobalActionValue)value);
                    return object;
                }
                case Download: {
                    Object object = this.processDownload((DownloadKey)key, (DownloadValue)value);
                    return object;
                }
                case ConfigProperty: {
                    Object object = this.processConfigProperty((ConfigPropertyKey)key, (ConfigPropertyValue)value);
                    return object;
                }
                case ArtifactOwner: {
                    Object object = this.processArtifactOwnerMessage((ArtifactOwnerKey)key, (ArtifactOwnerValue)value);
                    return object;
                }
                case CommentId: {
                    Object object = this.processCommentId((CommentIdKey)key, (CommentIdValue)value);
                    return object;
                }
                case Comment: {
                    Object object = this.processComment((CommentKey)key, (CommentValue)value);
                    return object;
                }
            }
            this.log.warn("Unrecognized message type: {}", record.key());
            throw new RegistryStorageException("Unexpected message type: " + messageType.name());
        }
        finally {
            this.log.debug("Clearing tenant id after message processed");
            this.tenantContext.clearContext();
        }
    }

    private Object processGlobalAction(GlobalActionKey key, GlobalActionValue value) {
        switch (value.getAction()) {
            case DELETE_ALL_USER_DATA: {
                this.sqlStore.deleteAllUserData();
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processDownload(DownloadKey key, DownloadValue value) {
        switch (value.getAction()) {
            case CREATE: {
                return this.sqlStore.createDownload(value.getDownloadContext());
            }
            case DELETE: {
                return this.sqlStore.consumeDownload(key.getDownloadId());
            }
        }
        return this.unsupported(key, value);
    }

    private Object processConfigProperty(ConfigPropertyKey key, ConfigPropertyValue value) {
        switch (value.getAction()) {
            case UPDATE: {
                DynamicConfigPropertyDto dto = new DynamicConfigPropertyDto(key.getPropertyName(), value.getValue());
                this.sqlStore.setConfigProperty(dto);
                return null;
            }
            case DELETE: {
                this.sqlStore.deleteConfigProperty(key.getPropertyName());
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processGroupMessage(GroupKey key, GroupValue value) {
        Supplier<GroupMetaDataDto> buildGroup = () -> GroupMetaDataDto.builder().groupId(key.getGroupId()).description(value.getDescription()).artifactsType(value.getArtifactsType()).createdBy(value.getCreatedBy()).createdOn(value.getCreatedOn()).modifiedBy(value.getModifiedBy()).modifiedOn(value.getModifiedOn()).properties(value.getProperties()).build();
        switch (value.getAction()) {
            case CREATE: {
                this.sqlStore.createGroup(buildGroup.get());
                return null;
            }
            case UPDATE: {
                this.sqlStore.updateGroupMetaData(buildGroup.get());
                return null;
            }
            case DELETE: {
                if (value.isOnlyArtifacts()) {
                    this.sqlStore.deleteArtifacts(key.getGroupId());
                } else {
                    this.sqlStore.deleteGroup(key.getGroupId());
                }
                return null;
            }
            case IMPORT: {
                GroupEntity entity = new GroupEntity();
                entity.artifactsType = value.getArtifactsType();
                entity.createdBy = value.getCreatedBy();
                entity.createdOn = value.getCreatedOn();
                entity.description = value.getDescription();
                entity.groupId = key.getGroupId();
                entity.modifiedBy = value.getModifiedBy();
                entity.modifiedOn = value.getModifiedOn();
                entity.properties = value.getProperties();
                this.sqlStore.importGroup(entity);
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processArtifactMessage(ArtifactKey key, final ArtifactValue value) throws RegistryStorageException {
        try {
            IdGenerator globalIdGenerator = new IdGenerator(){

                public Long generate(Handle handle) {
                    return value.getGlobalId();
                }
            };
            switch (value.getAction()) {
                case CREATE: {
                    return this.sqlStore.createArtifactWithMetadata(key.getGroupId(), key.getArtifactId(), value.getVersion(), value.getArtifactType(), value.getContentHash(), value.getCreatedBy(), value.getCreatedOn(), value.getMetaData(), globalIdGenerator);
                }
                case UPDATE: {
                    return this.sqlStore.updateArtifactWithMetadata(key.getGroupId(), key.getArtifactId(), value.getVersion(), value.getArtifactType(), value.getContentHash(), value.getCreatedBy(), value.getCreatedOn(), value.getMetaData(), globalIdGenerator);
                }
                case DELETE: {
                    return this.sqlStore.deleteArtifact(key.getGroupId(), key.getArtifactId());
                }
                case IMPORT: {
                    ArtifactVersionEntity entity = new ArtifactVersionEntity();
                    entity.globalId = value.getGlobalId();
                    entity.groupId = key.getGroupId();
                    entity.artifactId = key.getArtifactId();
                    entity.version = value.getVersion();
                    entity.versionId = value.getVersionId();
                    entity.artifactType = value.getArtifactType();
                    entity.state = value.getState();
                    entity.name = value.getMetaData().getName();
                    entity.description = value.getMetaData().getDescription();
                    entity.createdBy = value.getCreatedBy();
                    entity.createdOn = value.getCreatedOn().getTime();
                    entity.labels = value.getMetaData().getLabels();
                    entity.properties = value.getMetaData().getProperties();
                    entity.isLatest = value.getLatest();
                    entity.contentId = value.getContentId();
                    this.sqlStore.importArtifactVersion(entity);
                    return null;
                }
            }
            return this.unsupported(key, value);
        }
        catch (ArtifactAlreadyExistsException | ArtifactNotFoundException e) {
            this.submitter.send(key, null);
            throw e;
        }
    }

    private Object processArtifactRuleMessage(ArtifactRuleKey key, ArtifactRuleValue value) {
        switch (value.getAction()) {
            case CREATE: {
                this.sqlStore.createArtifactRule(key.getGroupId(), key.getArtifactId(), key.getRuleType(), value.getConfig());
                return null;
            }
            case UPDATE: {
                this.sqlStore.updateArtifactRule(key.getGroupId(), key.getArtifactId(), key.getRuleType(), value.getConfig());
                return null;
            }
            case DELETE: {
                this.sqlStore.deleteArtifactRule(key.getGroupId(), key.getArtifactId(), key.getRuleType());
                return null;
            }
            case IMPORT: {
                ArtifactRuleEntity entity = new ArtifactRuleEntity();
                entity.groupId = key.getGroupId();
                entity.artifactId = key.getArtifactId();
                entity.type = key.getRuleType();
                entity.configuration = value.getConfig().getConfiguration();
                this.sqlStore.importArtifactRule(entity);
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processArtifactOwnerMessage(ArtifactOwnerKey key, ArtifactOwnerValue value) {
        switch (value.getAction()) {
            case UPDATE: {
                this.sqlStore.updateArtifactOwner(key.getGroupId(), key.getArtifactId(), new ArtifactOwnerDto(value.getOwner()));
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processArtifactVersion(ArtifactVersionKey key, ArtifactVersionValue value) {
        switch (value.getAction()) {
            case UPDATE: {
                this.sqlStore.updateArtifactVersionMetaDataAndState(key.getGroupId(), key.getArtifactId(), key.getVersion(), value.getMetaData(), value.getState());
                return null;
            }
            case DELETE: {
                this.sqlStore.deleteArtifactVersion(key.getGroupId(), key.getArtifactId(), key.getVersion());
                return null;
            }
            case CLEAR: {
                this.sqlStore.deleteArtifactVersionMetaData(key.getGroupId(), key.getArtifactId(), key.getVersion());
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processContent(ContentKey key, ContentValue value) {
        switch (value.getAction()) {
            case CREATE: {
                if (!this.sqlStore.isContentExists(key.getContentHash())) {
                    this.sqlStore.storeContent(key.getContentId(), key.getContentHash(), value.getCanonicalHash(), value.getContent(), value.getSerializedReferences());
                }
                return null;
            }
            case IMPORT: {
                if (!this.sqlStore.isContentExists(key.getContentId())) {
                    ContentEntity entity = new ContentEntity();
                    entity.contentId = key.getContentId();
                    entity.contentHash = key.getContentHash();
                    entity.canonicalHash = value.getCanonicalHash();
                    entity.contentBytes = value.getContent().bytes();
                    entity.serializedReferences = value.getSerializedReferences();
                    this.sqlStore.importContent(entity);
                }
                return null;
            }
            case UPDATE: {
                this.sqlStore.updateContentCanonicalHash(value.getCanonicalHash(), key.getContentId(), key.getContentHash());
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processGlobalRule(GlobalRuleKey key, GlobalRuleValue value) {
        switch (value.getAction()) {
            case CREATE: {
                this.sqlStore.createGlobalRule(key.getRuleType(), value.getConfig());
                return null;
            }
            case UPDATE: {
                this.sqlStore.updateGlobalRule(key.getRuleType(), value.getConfig());
                return null;
            }
            case DELETE: {
                this.sqlStore.deleteGlobalRule(key.getRuleType());
                return null;
            }
            case IMPORT: {
                GlobalRuleEntity entity = new GlobalRuleEntity();
                entity.ruleType = key.getRuleType();
                entity.configuration = value.getConfig().getConfiguration();
                this.sqlStore.importGlobalRule(entity);
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processRoleMapping(RoleMappingKey key, RoleMappingValue value) {
        switch (value.getAction()) {
            case CREATE: {
                this.sqlStore.createRoleMapping(key.getPrincipalId(), value.getRole(), value.getPrincipalName());
                return null;
            }
            case UPDATE: {
                this.sqlStore.updateRoleMapping(key.getPrincipalId(), value.getRole());
                return null;
            }
            case DELETE: {
                this.sqlStore.deleteRoleMapping(key.getPrincipalId());
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processGlobalId(GlobalIdKey key, GlobalIdValue value) {
        switch (value.getAction()) {
            case CREATE: {
                return this.sqlStore.nextGlobalId();
            }
            case RESET: {
                this.sqlStore.resetGlobalId();
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processContentId(ContentIdKey key, ContentIdValue value) {
        switch (value.getAction()) {
            case CREATE: {
                return this.sqlStore.nextContentId();
            }
            case RESET: {
                this.sqlStore.resetContentId();
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processCommentId(CommentIdKey key, CommentIdValue value) {
        switch (value.getAction()) {
            case CREATE: {
                return this.sqlStore.nextCommentId();
            }
            case RESET: {
                this.sqlStore.resetCommentId();
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object processLogConfig(LogConfigKey key, LogConfigValue value) {
        switch (value.getAction()) {
            case UPDATE: {
                this.sqlStore.setLogConfiguration(value.getConfig());
                return null;
            }
            case DELETE: {
                this.sqlStore.removeLogConfiguration(value.getConfig().getLogger());
                return null;
            }
        }
        return this.unsupported(key, value);
    }

    private Object unsupported(MessageKey key, AbstractMessageValue value) {
        String m = String.format("Unsupported action '%s' for message type '%s'", new Object[]{value.getAction(), key.getType().name()});
        this.log.warn(m);
        throw new RegistryStorageException(m);
    }

    private Object processComment(CommentKey key, CommentValue value) {
        switch (value.getAction()) {
            case CREATE: {
                return this.sqlStore.createArtifactVersionComment(key.getGroupId(), key.getArtifactId(), key.getVersion(), (IdGenerator)new IdGenerator.StaticIdGenerator(Long.valueOf(Long.parseLong(key.getCommentId()))), value.getCreatedBy(), value.getCreatedOn(), value.getValue());
            }
            case UPDATE: {
                this.sqlStore.updateArtifactVersionComment(key.getGroupId(), key.getArtifactId(), key.getVersion(), key.getCommentId(), value.getValue());
                return null;
            }
            case DELETE: {
                this.sqlStore.deleteArtifactVersionComment(key.getGroupId(), key.getArtifactId(), key.getVersion(), key.getCommentId());
                return null;
            }
            case IMPORT: {
                CommentEntity entity = new CommentEntity();
                entity.commentId = key.getCommentId();
                entity.globalId = value.getGlobalId();
                entity.createdBy = value.getCreatedBy();
                entity.createdOn = value.getCreatedOn().getTime();
                entity.value = value.getValue();
                this.sqlStore.importComment(entity);
                return null;
            }
        }
        return this.unsupported(key, value);
    }
}

