/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.sql;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.impl.sql.AbstractSqlRegistryStorage;
import io.apicurio.registry.storage.impl.sql.HandleFactory;
import io.apicurio.registry.storage.impl.sql.IdGenerator;
import io.apicurio.registry.storage.impl.sql.SqlUtil;
import io.apicurio.registry.storage.impl.sql.jdb.Query;
import io.apicurio.registry.storage.impl.sql.jdb.Update;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.impexp.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.CommentEntity;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.apicurio.registry.utils.impexp.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.GroupEntity;
import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.transaction.Transactional;
import java.util.Date;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="KafkaSqlStore")
@Logged
public class KafkaSqlStore
extends AbstractSqlRegistryStorage {
    @Inject
    Logger log;
    @Inject
    HandleFactory handles;

    public KafkaSqlStore() {
        super(false);
    }

    void onStart(@Observes StartupEvent ev) {
    }

    @Transactional
    public long nextGlobalId() {
        return (Long)this.handles.withHandleNoException(x$0 -> this.nextGlobalId(x$0));
    }

    @Transactional
    public long nextContentId() {
        return (Long)this.handles.withHandleNoException(x$0 -> this.nextContentId(x$0));
    }

    @Transactional
    public long nextCommentId() {
        return (Long)this.handles.withHandleNoException(x$0 -> this.nextCommentId(x$0));
    }

    public boolean isContentExists(String contentHash) throws RegistryStorageException {
        return (Boolean)this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectContentCountByHash();
            return (Integer)((Query)((Query)handle.createQuery(sql).bind(0, contentHash)).bind(1, this.tenantContext().tenantId())).mapTo(Integer.class).one() > 0;
        });
    }

    public boolean isArtifactRuleExists(String groupId, String artifactId, RuleType rule) throws RegistryStorageException {
        return (Boolean)this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectArtifactRuleCountByType();
            return (Integer)((Query)((Query)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).bind(1, SqlUtil.normalizeGroupId((String)groupId))).bind(2, artifactId)).bind(3, rule.name())).mapTo(Integer.class).one() > 0;
        });
    }

    public boolean isGlobalRuleExists(RuleType rule) throws RegistryStorageException {
        return (Boolean)this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectGlobalRuleCountByType();
            return (Integer)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).bind(1, rule.name())).mapTo(Integer.class).one() > 0;
        });
    }

    public boolean isRoleMappingExists(String principalId) {
        return (Boolean)this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectRoleMappingCountByPrincipal();
            return (Integer)((Query)((Query)handle.createQuery(sql).bind(0, this.tenantContext().tenantId())).bind(1, principalId)).mapTo(Integer.class).one() > 0;
        });
    }

    @Transactional
    public void storeContent(long contentId, String contentHash, String canonicalHash, ContentHandle content, String serializedReferences) throws RegistryStorageException {
        this.handles.withHandleNoException(handle -> {
            if (!this.isContentExists(contentId)) {
                byte[] contentBytes = content.bytes();
                String sql = this.sqlStatements().importContent();
                ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, this.tenantContext().tenantId())).bind(1, Long.valueOf(contentId))).bind(2, canonicalHash)).bind(3, contentHash)).bind(4, contentBytes)).bind(5, serializedReferences)).execute();
                this.insertReferences(handle, contentId, SqlUtil.deserializeReferences((String)serializedReferences));
            }
            return null;
        });
    }

    @Transactional
    public ArtifactMetaDataDto createArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, String contentHash, String createdBy, Date createdOn, EditableArtifactMetaDataDto metaData, IdGenerator globalIdGenerator) throws ArtifactNotFoundException, RegistryStorageException {
        long contentId = this.contentIdFromHash(contentHash);
        if (metaData == null) {
            metaData = new EditableArtifactMetaDataDto();
        }
        return super.createArtifactWithMetadata(groupId, artifactId, version, artifactType, contentId, createdBy, createdOn, metaData, globalIdGenerator);
    }

    @Transactional
    public ArtifactMetaDataDto updateArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, String contentHash, String createdBy, Date createdOn, EditableArtifactMetaDataDto metaData, IdGenerator globalIdGenerator) throws ArtifactNotFoundException, RegistryStorageException {
        long contentId = this.contentIdFromHash(contentHash);
        if (metaData == null) {
            metaData = new EditableArtifactMetaDataDto();
        }
        return super.updateArtifactWithMetadata(groupId, artifactId, version, artifactType, contentId, createdBy, createdOn, metaData, globalIdGenerator);
    }

    @Transactional
    public void updateArtifactVersionMetaDataAndState(String groupId, String artifactId, String version, EditableArtifactMetaDataDto metaData, ArtifactState state) {
        this.updateArtifactVersionMetaData(groupId, artifactId, version, metaData);
        this.updateArtifactState(groupId, artifactId, version, state);
    }

    public long contentIdFromHash(String contentHash) {
        return (Long)this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().selectContentIdByHash();
            return (Long)((Query)((Query)handle.createQuery(sql).bind(0, contentHash)).bind(1, this.tenantContext().tenantId())).mapTo(Long.class).one();
        });
    }

    @Transactional
    public void importArtifactRule(ArtifactRuleEntity entity) {
        this.handles.withHandleNoException(handle -> {
            super.importArtifactRule(handle, entity);
            return null;
        });
    }

    @Transactional
    public void importArtifactVersion(ArtifactVersionEntity entity) {
        this.handles.withHandleNoException(handle -> {
            super.importArtifactVersion(handle, entity);
            return null;
        });
    }

    @Transactional
    public void importContent(ContentEntity entity) {
        this.handles.withHandleNoException(handle -> {
            super.importContent(handle, entity);
            return null;
        });
    }

    @Transactional
    public void importGlobalRule(GlobalRuleEntity entity) {
        this.handles.withHandleNoException(handle -> {
            super.importGlobalRule(handle, entity);
            return null;
        });
    }

    @Transactional
    public void importGroup(GroupEntity entity) {
        this.handles.withHandleNoException(handle -> {
            super.importGroup(handle, entity);
            return null;
        });
    }

    @Transactional
    public void importComment(CommentEntity entity) {
        this.handles.withHandleNoException(handle -> {
            super.importComment(handle, entity);
            return null;
        });
    }

    @Transactional
    public void resetContentId() {
        this.handles.withHandleNoException(handle -> {
            super.resetContentId(handle);
            return null;
        });
    }

    @Transactional
    public void resetCommentId() {
        this.handles.withHandleNoException(handle -> {
            super.resetCommentId(handle);
            return null;
        });
    }

    @Transactional
    public void resetGlobalId() {
        this.handles.withHandleNoException(handle -> {
            super.resetGlobalId(handle);
            return null;
        });
    }

    @Transactional
    public void updateContentCanonicalHash(String newCanonicalHash, long contentId, String contentHash) {
        this.handles.withHandleNoException(handle -> {
            String sql = this.sqlStatements().updateContentCanonicalHash();
            int rowCount = ((Update)((Update)((Update)((Update)handle.createUpdate(sql).bind(0, newCanonicalHash)).bind(1, this.tenantContext().tenantId())).bind(2, Long.valueOf(contentId))).bind(3, contentHash)).execute();
            if (rowCount == 0) {
                this.log.warn("update content canonicalHash, no row match contentId {} contentHash {}", (Object)contentId, (Object)contentHash);
            }
            return null;
        });
    }

    @Transactional
    public String resolveVersion(String groupId, String artifactId, String version) {
        return super.resolveVersion(groupId, artifactId, version);
    }

    @Transactional
    public CommentDto createArtifactVersionComment(String groupId, String artifactId, String version, IdGenerator commentId, String createdBy, Date createdOn, String value) {
        return super.createArtifactVersionComment(groupId, artifactId, version, commentId, createdBy, createdOn, value);
    }
}

