/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.HashMap;
import java.util.Map;

@RegisterForReflection
public enum ActionType {
    CREATE(1),
    UPDATE(2),
    DELETE(3),
    CLEAR(4),
    IMPORT(5),
    RESET(6),
    DELETE_ALL_USER_DATA(7);

    private final byte ord;
    private static final Map<Byte, ActionType> ordIndex;
    private static final Map<String, ActionType> normalizedStringMapping;

    private ActionType(int ord) {
        this.ord = (byte)ord;
    }

    public final byte getOrd() {
        return this.ord;
    }

    public static ActionType fromOrd(byte ord) {
        ActionType res = ordIndex.get(ord);
        if (res == null) {
            throw new IllegalArgumentException(String.format("Could not find ActionType with ord value %s", ord));
        }
        return res;
    }

    @JsonValue
    public Object serialize() {
        return this.getOrd();
    }

    @JsonCreator
    public static ActionType deserialize(Object value) {
        String normalizedString;
        ActionType res;
        if (value instanceof Number) {
            Number num = (Number)value;
            if (num.longValue() > 127L) {
                throw new IllegalArgumentException(String.format("Unexpectedly high numeric value %s for ActionType ord", num));
            }
            return ActionType.fromOrd(num.byteValue());
        }
        if (value instanceof String && (res = normalizedStringMapping.get(normalizedString = ((String)value).toLowerCase())) != null) {
            return res;
        }
        throw new IllegalArgumentException(String.format("Could not deserialize value %s to ActionType", value));
    }

    static {
        ordIndex = new HashMap<Byte, ActionType>();
        normalizedStringMapping = new HashMap<String, ActionType>();
        for (ActionType at : ActionType.values()) {
            if (ordIndex.containsKey(at.getOrd())) {
                throw new IllegalArgumentException(String.format("Duplicate ord value %d for ActionType %s", at.getOrd(), at.name()));
            }
            ordIndex.put(at.getOrd(), at);
            String normalizedString = at.name().toLowerCase();
            if (normalizedStringMapping.containsKey(normalizedString)) {
                throw new IllegalArgumentException(String.format("Duplicate normalized string value %s for ActionType %s", normalizedString, at.name()));
            }
            normalizedStringMapping.put(normalizedString, at);
        }
    }
}

