/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.values;

import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.values.AbstractMessageValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ActionType;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.Map;

@RegisterForReflection
public class GroupValue
extends AbstractMessageValue {
    private String description;
    private String artifactsType;
    private String createdBy;
    private long createdOn;
    private String modifiedBy;
    private long modifiedOn;
    private Map<String, String> properties;
    private boolean onlyArtifacts;

    public static final GroupValue create(ActionType action, boolean onlyArtifacts) {
        GroupValue value = new GroupValue();
        value.setAction(action);
        value.setOnlyArtifacts(onlyArtifacts);
        return value;
    }

    public static final GroupValue create(ActionType action, GroupMetaDataDto meta) {
        GroupValue value = new GroupValue();
        value.setAction(action);
        value.setDescription(meta.getDescription());
        value.setArtifactsType(meta.getArtifactsType());
        value.setCreatedBy(meta.getCreatedBy());
        value.setCreatedOn(meta.getCreatedOn());
        value.setModifiedBy(meta.getModifiedBy());
        value.setModifiedOn(meta.getModifiedOn());
        value.setProperties(meta.getProperties());
        return value;
    }

    @Override
    public MessageType getType() {
        return MessageType.Group;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getArtifactsType() {
        return this.artifactsType;
    }

    public void setArtifactsType(String artifactsType) {
        this.artifactsType = artifactsType;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(long createdOn) {
        this.createdOn = createdOn;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public long getModifiedOn() {
        return this.modifiedOn;
    }

    public void setModifiedOn(long modifiedOn) {
        this.modifiedOn = modifiedOn;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isOnlyArtifacts() {
        return this.onlyArtifacts;
    }

    public void setOnlyArtifacts(boolean onlyArtifacts) {
        this.onlyArtifacts = onlyArtifacts;
    }

    public String toString() {
        return "GroupValue(description=" + this.getDescription() + ", artifactsType=" + this.getArtifactsType() + ", createdBy=" + this.getCreatedBy() + ", createdOn=" + this.getCreatedOn() + ", modifiedBy=" + this.getModifiedBy() + ", modifiedOn=" + this.getModifiedOn() + ", properties=" + this.getProperties() + ", onlyArtifacts=" + this.isOnlyArtifacts() + ")";
    }
}

