/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.kafkasql.values;

import io.apicurio.registry.storage.impl.kafkasql.MessageType;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactOwnerValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactRuleValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ArtifactVersionValue;
import io.apicurio.registry.storage.impl.kafkasql.values.CommentIdValue;
import io.apicurio.registry.storage.impl.kafkasql.values.CommentValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ConfigPropertyValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ContentIdValue;
import io.apicurio.registry.storage.impl.kafkasql.values.ContentValue;
import io.apicurio.registry.storage.impl.kafkasql.values.DownloadValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GlobalActionValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GlobalIdValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GlobalRuleValue;
import io.apicurio.registry.storage.impl.kafkasql.values.GroupValue;
import io.apicurio.registry.storage.impl.kafkasql.values.LogConfigValue;
import io.apicurio.registry.storage.impl.kafkasql.values.MessageValue;
import io.apicurio.registry.storage.impl.kafkasql.values.RoleMappingValue;
import java.util.HashMap;
import java.util.Map;

public class MessageTypeToValueClass {
    private static final MessageType[] types = MessageType.values();
    private static final Map<MessageType, Class<? extends MessageValue>> index = new HashMap<MessageType, Class<? extends MessageValue>>();

    public static final Class<? extends MessageValue> typeToValue(MessageType type) {
        return index.get((Object)type);
    }

    public static final Class<? extends MessageValue> ordToValue(byte typeOrdinal) {
        MessageType type = MessageType.fromOrd(typeOrdinal);
        return MessageTypeToValueClass.typeToValue(type);
    }

    static {
        block19: for (MessageType type : types) {
            switch (type) {
                case Bootstrap: {
                    continue block19;
                }
                case Group: {
                    index.put(type, GroupValue.class);
                    continue block19;
                }
                case Artifact: {
                    index.put(type, ArtifactValue.class);
                    continue block19;
                }
                case ArtifactRule: {
                    index.put(type, ArtifactRuleValue.class);
                    continue block19;
                }
                case Content: {
                    index.put(type, ContentValue.class);
                    continue block19;
                }
                case GlobalRule: {
                    index.put(type, GlobalRuleValue.class);
                    continue block19;
                }
                case LogConfig: {
                    index.put(type, LogConfigValue.class);
                    continue block19;
                }
                case ArtifactVersion: {
                    index.put(type, ArtifactVersionValue.class);
                    continue block19;
                }
                case GlobalId: {
                    index.put(type, GlobalIdValue.class);
                    continue block19;
                }
                case ContentId: {
                    index.put(type, ContentIdValue.class);
                    continue block19;
                }
                case RoleMapping: {
                    index.put(type, RoleMappingValue.class);
                    continue block19;
                }
                case GlobalAction: {
                    index.put(type, GlobalActionValue.class);
                    continue block19;
                }
                case Download: {
                    index.put(type, DownloadValue.class);
                    continue block19;
                }
                case ConfigProperty: {
                    index.put(type, ConfigPropertyValue.class);
                    continue block19;
                }
                case ArtifactOwner: {
                    index.put(type, ArtifactOwnerValue.class);
                    continue block19;
                }
                case CommentId: {
                    index.put(type, CommentIdValue.class);
                    continue block19;
                }
                case Comment: {
                    index.put(type, CommentValue.class);
                    continue block19;
                }
                default: {
                    throw new RuntimeException("[MessageTypeToValueClass] Type not mapped: " + type);
                }
            }
        }
    }
}

