/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class OidcConfigurationMetadata {
    private static final String ISSUER = "issuer";
    private static final String TOKEN_ENDPOINT = "token_endpoint";
    private static final String INTROSPECTION_ENDPOINT = "introspection_endpoint";
    private static final String AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private static final String JWKS_ENDPOINT = "jwks_uri";
    private static final String USERINFO_ENDPOINT = "userinfo_endpoint";
    private static final String END_SESSION_ENDPOINT = "end_session_endpoint";
    private static final String SCOPES_SUPPORTED = "scopes_supported";
    private final String tokenUri;
    private final String introspectionUri;
    private final String authorizationUri;
    private final String jsonWebKeySetUri;
    private final String userInfoUri;
    private final String endSessionUri;
    private final String issuer;
    private final JsonObject json;

    public /* synthetic */ OidcConfigurationMetadata() {
    }

    public OidcConfigurationMetadata(String tokenUri, String introspectionUri, String authorizationUri, String jsonWebKeySetUri, String userInfoUri, String endSessionUri, String issuer) {
        this.tokenUri = tokenUri;
        this.introspectionUri = introspectionUri;
        this.authorizationUri = authorizationUri;
        this.jsonWebKeySetUri = jsonWebKeySetUri;
        this.userInfoUri = userInfoUri;
        this.endSessionUri = endSessionUri;
        this.issuer = issuer;
        this.json = null;
    }

    public OidcConfigurationMetadata(JsonObject wellKnownConfig) {
        this(wellKnownConfig, null);
    }

    public OidcConfigurationMetadata(JsonObject wellKnownConfig, OidcConfigurationMetadata localMetadataConfig) {
        this.tokenUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, TOKEN_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.tokenUri);
        this.introspectionUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, INTROSPECTION_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.introspectionUri);
        this.authorizationUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, AUTHORIZATION_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.authorizationUri);
        this.jsonWebKeySetUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, JWKS_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.jsonWebKeySetUri);
        this.userInfoUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, USERINFO_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.userInfoUri);
        this.endSessionUri = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, END_SESSION_ENDPOINT, localMetadataConfig == null ? null : localMetadataConfig.endSessionUri);
        this.issuer = OidcConfigurationMetadata.getMetadataValue(wellKnownConfig, ISSUER, localMetadataConfig == null ? null : localMetadataConfig.issuer);
        this.json = wellKnownConfig;
    }

    private static String getMetadataValue(JsonObject wellKnownConfig, String propertyName, String localValue) {
        return localValue != null ? localValue : wellKnownConfig.getString(propertyName);
    }

    public String getTokenUri() {
        return this.tokenUri;
    }

    public String getIntrospectionUri() {
        return this.introspectionUri;
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public String getJsonWebKeySetUri() {
        return this.jsonWebKeySetUri;
    }

    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    public String getEndSessionUri() {
        return this.endSessionUri;
    }

    public List<String> getSupportedScopes() {
        return this.getStringList(SCOPES_SUPPORTED);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String get(String propertyName) {
        return this.json == null ? null : this.json.getString(propertyName);
    }

    public List<String> getStringList(String propertyName) {
        JsonArray array;
        JsonArray jsonArray = array = this.json == null ? null : this.json.getJsonArray(propertyName);
        if (array != null) {
            List values = array.getList();
            return Collections.unmodifiableList(values);
        }
        return null;
    }

    public boolean contains(String propertyName) {
        return this.json == null ? false : this.json.containsKey(propertyName);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.json.fieldNames());
    }
}

