/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.BearerAuthenticationMechanism;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;

@ApplicationScoped
public class OidcAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static HttpCredentialTransport OIDC_SERVICE_TRANSPORT = new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, "Bearer");
    private static HttpCredentialTransport OIDC_WEB_APP_TRANSPORT = new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION_CODE, "code");
    private final BearerAuthenticationMechanism bearerAuth;
    private final CodeAuthenticationMechanism codeAuth;
    private final DefaultTenantConfigResolver resolver;

    public /* synthetic */ OidcAuthenticationMechanism() {
    }

    public OidcAuthenticationMechanism(DefaultTenantConfigResolver resolver) {
        this.bearerAuth = new BearerAuthenticationMechanism();
        this.codeAuth = new CodeAuthenticationMechanism();
        this.resolver = resolver;
        this.bearerAuth.init((HttpAuthenticationMechanism)this, resolver);
        this.codeAuth.init((HttpAuthenticationMechanism)this, resolver);
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        OidcAuthenticationMechanism.setTenantIdAttribute(context);
        return this.resolve(context).chain((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        OidcAuthenticationMechanism.setTenantIdAttribute(context);
        return this.resolve(context).chain((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Uni<OidcTenantConfig> resolve(RoutingContext context) {
        return this.resolver.resolveConfig(context).map((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isWebApp(RoutingContext context, OidcTenantConfig oidcConfig) {
        OidcTenantConfig.ApplicationType applicationType = oidcConfig.applicationType.orElse(OidcTenantConfig.ApplicationType.SERVICE);
        if (OidcTenantConfig.ApplicationType.HYBRID == applicationType) {
            return context.request().getHeader("Authorization") == null;
        }
        return OidcTenantConfig.ApplicationType.WEB_APP == applicationType;
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        OidcAuthenticationMechanism.setTenantIdAttribute(context);
        return this.resolve(context).onItem().transform((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void setTenantIdAttribute(RoutingContext context) {
        for (String cookieName : context.cookieMap().keySet()) {
            if (cookieName.startsWith("q_session")) {
                OidcAuthenticationMechanism.setTenantIdAttribute(context, "q_session", cookieName);
                continue;
            }
            if (!cookieName.startsWith("q_auth")) continue;
            OidcAuthenticationMechanism.setTenantIdAttribute(context, "q_auth", cookieName);
        }
    }

    private static void setTenantIdAttribute(RoutingContext context, String cookiePrefix, String cookieName) {
        if (cookieName.length() == cookiePrefix.length()) {
            context.put("tenant-id", (Object)"Default");
        } else {
            String suffix = cookieName.substring(cookiePrefix.length() + 1);
            int index = suffix.indexOf("_");
            String tenantId = index == -1 ? suffix : suffix.substring(0, index);
            context.put("tenant-id", (Object)tenantId);
        }
    }

    public int getPriority() {
        return 1001;
    }
}

