/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.multitenancy.ApicurioTenantContext;
import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.common.apps.multitenancy.exceptions.TenantNotAuthorizedException;
import io.apicurio.registry.auth.AdminOverride;
import io.apicurio.registry.auth.AuthConfig;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.OwnerBasedAccessController;
import io.apicurio.registry.auth.RoleBasedAccessApiOperation;
import io.apicurio.registry.auth.RoleBasedAccessController;
import io.quarkus.security.ForbiddenException;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.slf4j.Logger;

@Authorized
@Interceptor
@Priority(value=2000)
public class AuthorizedInterceptor {
    @Inject
    Logger log;
    @Inject
    AuthConfig authConfig;
    @Inject
    SecurityIdentity securityIdentity;
    @Inject
    Instance<JsonWebToken> jsonWebToken;
    @Inject
    AdminOverride adminOverride;
    @Inject
    RoleBasedAccessController rbac;
    @Inject
    OwnerBasedAccessController obac;
    @Inject
    MultitenancyProperties mtProperties;
    @Inject
    TenantContext tenantContext;
    @ConfigProperty(name="registry.organization-id.claim-name")
    @Info(category="mt", description="Organization ID claim name", availableSince="2.1.0.Final")
    List<String> organizationIdClaims;

    @AroundInvoke
    public Object authorizeMethod(InvocationContext context) throws Exception {
        RoleBasedAccessApiOperation rbacOpAnnotation;
        if (this.mtProperties.isMultitenancyEnabled()) {
            if (!this.tenantContext.isLoaded()) {
                this.log.warn("Request is rejected because the tenant could not be found, and access to default tenant is disabled in a multitenant deployment");
                throw new ForbiddenException("Default tenant access is not allowed in multitenancy mode.");
            }
            if (this.mtProperties.isMultitenancyAuthorizationEnabled()) {
                this.checkTenantAuthorization(this.tenantContext.currentContext());
            }
        }
        if ((rbacOpAnnotation = context.getMethod().getAnnotation(RoleBasedAccessApiOperation.class)) != null && !this.authConfig.isApplicationRbacEnabled()) {
            this.log.warn("Access to /admin/roleMappings denied because application managed RBAC is not enabled.");
            throw new ForbiddenException("Application RBAC not enabled.");
        }
        if (!this.authConfig.authenticationEnabled) {
            return context.proceed();
        }
        this.log.trace("Authentication enabled, protected resource: " + context.getMethod());
        Authorized annotation = context.getMethod().getAnnotation(Authorized.class);
        if (this.securityIdentity == null || this.securityIdentity.isAnonymous()) {
            if (annotation.level() == AuthorizedLevel.None) {
                this.log.trace("Anonymous user is being granted access to unprotected operation.");
                return context.proceed();
            }
            if (this.authConfig.anonymousReadAccessEnabled.get().booleanValue() && annotation.level() == AuthorizedLevel.Read) {
                this.log.trace("Anonymous user is being granted access to read-only operation.");
                return context.proceed();
            }
            this.log.warn("Authentication credentials missing and required for protected endpoint.");
            throw new UnauthorizedException("User is not authenticated.");
        }
        this.log.trace("principalId:" + this.securityIdentity.getPrincipal().getName());
        if (annotation.level() == AuthorizedLevel.None) {
            return context.proceed();
        }
        if (this.adminOverride.isAdmin()) {
            this.log.trace("Admin override successful.");
            return context.proceed();
        }
        if (this.authConfig.authenticatedReadAccessEnabled.get().booleanValue() && annotation.level() == AuthorizedLevel.Read) {
            return context.proceed();
        }
        if (this.authConfig.roleBasedAuthorizationEnabled && !this.rbac.isAuthorized(context)) {
            this.log.warn("RBAC enabled and required role missing.");
            throw new ForbiddenException("User " + this.securityIdentity.getPrincipal().getName() + " is not authorized to perform the requested operation.");
        }
        if (this.authConfig.ownerOnlyAuthorizationEnabled.get().booleanValue() && !this.obac.isAuthorized(context)) {
            this.log.warn("OBAC enabled and operation not permitted due to wrong owner.");
            throw new ForbiddenException("User " + this.securityIdentity.getPrincipal().getName() + " is not authorized to perform the requested operation.");
        }
        return context.proceed();
    }

    private void checkTenantAuthorization(ApicurioTenantContext tenant) {
        if (this.authConfig.isAuthEnabled()) {
            if (!this.isTokenResolvable()) {
                this.log.debug("Tenant access attempted without JWT token for tenant {} [allowing because some endpoints allow anonymous access]", (Object)tenant.getTenantId());
                return;
            }
            String accessedOrganizationId = null;
            for (String organizationIdClaim : this.organizationIdClaims) {
                Optional claimValue = ((JsonWebToken)this.jsonWebToken.get()).claim(organizationIdClaim);
                if (!claimValue.isPresent()) continue;
                accessedOrganizationId = (String)claimValue.get();
                break;
            }
            if (null == accessedOrganizationId || !this.tenantCanAccessOrganization(tenant, accessedOrganizationId)) {
                this.log.warn("User not authorized to access tenant.");
                throw new TenantNotAuthorizedException("Tenant not authorized");
            }
        }
    }

    private boolean isTokenResolvable() {
        return this.jsonWebToken.isResolvable() && ((JsonWebToken)this.jsonWebToken.get()).getRawToken() != null;
    }

    private boolean tenantCanAccessOrganization(ApicurioTenantContext tenant, String accessedOrganizationId) {
        return tenant == null || accessedOrganizationId.equals(tenant.getOrganizationId());
    }
}

