/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v6.impl;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.rest.v6.SubjectsResource;
import io.apicurio.registry.ccompat.rest.v6.impl.AbstractResource;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import jakarta.interceptor.Interceptors;
import java.util.List;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SubjectsResourceImpl
extends AbstractResource
implements SubjectsResource {
    @Override
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<String> listSubjects() {
        return this.facade.getSubjects(false);
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public Schema findSchemaByContent(String subject, SchemaInfo request) throws Exception {
        return this.facade.getSchemaNormalize(subject, request, false);
    }

    @Override
    @Audited(extractParameters={"0", "artifact_id"})
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public List<Integer> deleteSubject(String subject) throws Exception {
        return this.facade.deleteSubject(subject, true);
    }
}

