/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v7;

import io.apicurio.registry.ccompat.dto.ExporterDto;
import io.apicurio.registry.ccompat.dto.ExporterStatus;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Map;

@Path(value="/apis/ccompat/v7/exporters")
@Consumes(value={"application/json", "application/octet-stream", "application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json"})
@Produces(value={"application/json", "application/octet-stream", "application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json"})
public interface ExporterResource {
    @GET
    public List<String> getExporters() throws Exception;

    @POST
    public String createExporter(ExporterDto var1) throws Exception;

    @GET
    @Path(value="/{exporter}")
    public String getExporter(@PathParam(value="exporter") String var1) throws Exception;

    @PUT
    @Path(value="/{exporter}")
    public String updateExporter(@PathParam(value="exporter") String var1, ExporterDto var2) throws Exception;

    @DELETE
    @Path(value="/{exporter}")
    public String deleteExporter(@PathParam(value="exporter") String var1) throws Exception;

    @PUT
    @Path(value="/{exporter}/pause")
    public String pauseExporter(@PathParam(value="exporter") String var1) throws Exception;

    @PUT
    @Path(value="/{exporter}/reset")
    public String resetExporter(@PathParam(value="exporter") String var1) throws Exception;

    @PUT
    @Path(value="/{exporter}/resume")
    public String resumeExporter(@PathParam(value="exporter") String var1) throws Exception;

    @PUT
    @Path(value="/{exporter}/config")
    public String updateExporterConfig(@PathParam(value="exporter") String var1, Map<String, String> var2) throws Exception;

    @GET
    @Path(value="/{exporter}/status")
    public ExporterStatus getExporterStatus(@PathParam(value="exporter") String var1) throws Exception;

    @GET
    @Path(value="/{exporter}/config")
    public Map<String, String> getExporterConfig(@PathParam(value="exporter") String var1) throws Exception;
}

