/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v7;

import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaId;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;

@Path(value="/apis/ccompat/v7/subjects/{subject}/versions")
@Consumes(value={"application/json", "application/octet-stream", "application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json"})
@Produces(value={"application/json", "application/octet-stream", "application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json"})
public interface SubjectVersionsResource {
    @GET
    public List<Integer> listVersions(@PathParam(value="subject") String var1, @HeaderParam(value="X-Registry-GroupId") String var2) throws Exception;

    @POST
    @Authorized(style=AuthorizedStyle.ArtifactOnly)
    public SchemaId register(@PathParam(value="subject") String var1, @NotNull SchemaInfo var2, @QueryParam(value="normalize") Boolean var3, @HeaderParam(value="X-Registry-GroupId") String var4) throws Exception;

    @GET
    @Path(value="/{version}")
    public Schema getSchemaByVersion(@PathParam(value="subject") String var1, @PathParam(value="version") String var2, @HeaderParam(value="X-Registry-GroupId") String var3) throws Exception;

    @DELETE
    @Path(value="/{version}")
    @Authorized(style=AuthorizedStyle.ArtifactOnly)
    public int deleteSchemaVersion(@PathParam(value="subject") String var1, @PathParam(value="version") String var2, @QueryParam(value="permanent") Boolean var3, @HeaderParam(value="X-Registry-GroupId") String var4) throws Exception;

    @GET
    @Path(value="/{version}/schema")
    public String getSchemaOnly(@PathParam(value="subject") String var1, @PathParam(value="version") String var2, @HeaderParam(value="X-Registry-GroupId") String var3) throws Exception;

    @GET
    @Path(value="/{version}/referencedby")
    public List<Long> getSchemasReferencedBy(@PathParam(value="subject") String var1, @PathParam(value="version") String var2, @HeaderParam(value="X-Registry-GroupId") String var3) throws Exception;
}

