/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest.v7.impl;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaId;
import io.apicurio.registry.ccompat.dto.SchemaInfo;
import io.apicurio.registry.ccompat.rest.v7.SubjectVersionsResource;
import io.apicurio.registry.ccompat.rest.v7.impl.AbstractResource;
import io.apicurio.registry.ccompat.store.FacadeConverter;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.ws.rs.BadRequestException;
import java.util.List;

@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SubjectVersionsResourceImpl
extends AbstractResource
implements SubjectVersionsResource {
    @Inject
    FacadeConverter converter;

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public List<Integer> listVersions(String subject, String groupId) throws Exception {
        return this.facade.getVersions(subject, groupId);
    }

    @Override
    @Audited(extractParameters={"0", "artifact_id"})
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public SchemaId register(String subject, SchemaInfo request, Boolean normalize, String groupId) throws Exception {
        boolean fnormalize = normalize == null ? Boolean.FALSE : normalize;
        Long id = this.facade.createSchema(subject, request.getSchema(), request.getSchemaType(), request.getReferences(), fnormalize, groupId);
        int sid = this.converter.convertUnsigned(id);
        return new SchemaId(sid);
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public Schema getSchemaByVersion(String subject, String version, String groupId) throws Exception {
        return this.facade.getSchema(subject, version, groupId);
    }

    @Override
    @Audited(extractParameters={"0", "artifact_id", "1", "version"})
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Write)
    public int deleteSchemaVersion(String subject, String version, Boolean permanent, String groupId) throws Exception {
        try {
            boolean fnormalize = permanent == null ? Boolean.FALSE : permanent;
            return this.facade.deleteSchema(subject, version, fnormalize, groupId);
        }
        catch (IllegalArgumentException ex) {
            throw new BadRequestException((Throwable)ex);
        }
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public String getSchemaOnly(String subject, String version, String groupId) throws Exception {
        return this.facade.getSchema(subject, version, groupId).getSchema();
    }

    @Override
    @Authorized(style=AuthorizedStyle.ArtifactOnly, level=AuthorizedLevel.Read)
    public List<Long> getSchemasReferencedBy(String subject, String version, String groupId) throws Exception {
        return this.facade.getContentIdsReferencingArtifact(subject, version, groupId);
    }
}

