/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.config;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.decorator.RegistryStorageDecorator;
import io.quarkus.scheduler.Scheduled;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryStorageConfigCache
extends RegistryStorageDecorator {
    private static final DynamicConfigPropertyDto NULL_DTO = new DynamicConfigPropertyDto();
    @Inject
    Logger log;
    @Inject
    TenantContext tenantContext;
    @ConfigProperty(name="registry.config.cache.enabled", defaultValue="true")
    @Info(category="cache", description="Registry cache enabled", availableSince="2.2.2.Final")
    boolean enabled;
    private Map<String, Map<String, DynamicConfigPropertyDto>> configCache = new ConcurrentHashMap<String, Map<String, DynamicConfigPropertyDto>>();
    private Instant lastRefresh = null;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int order() {
        return 5;
    }

    @Override
    public void setConfigProperty(DynamicConfigPropertyDto property) throws RegistryStorageException {
        super.setConfigProperty(property);
        this.invalidateCache(this.tenantContext.tenantId());
    }

    @Override
    public DynamicConfigPropertyDto getConfigProperty(String propertyName) {
        Map<String, DynamicConfigPropertyDto> tenantCache = this.getTenantCache();
        DynamicConfigPropertyDto propertyDto = tenantCache.computeIfAbsent(propertyName, key -> {
            DynamicConfigPropertyDto dto = super.getConfigProperty((String)key);
            if (dto == null) {
                dto = NULL_DTO;
            }
            return dto;
        });
        return propertyDto == NULL_DTO ? null : propertyDto;
    }

    private Map<String, DynamicConfigPropertyDto> getTenantCache() {
        return this.configCache.computeIfAbsent(this.tenantContext.tenantId(), tenantId -> new ConcurrentHashMap());
    }

    private void invalidateCache(String tenantId) {
        this.configCache.remove(tenantId);
    }

    @Scheduled(concurrentExecution=Scheduled.ConcurrentExecution.SKIP, every="{registry.config.refresh.every}")
    void run() {
        if (!this.enabled) {
            return;
        }
        try {
            this.log.debug("Running config property refresh job at {}", (Object)Instant.now());
            this.refresh();
        }
        catch (Exception ex) {
            this.log.error("Exception thrown when running config property refresh job.", (Throwable)ex);
        }
    }

    private void refresh() {
        Instant now = Instant.now();
        if (this.lastRefresh != null) {
            List<String> tenantIds = this.getTenantsWithStaleConfigProperties(this.lastRefresh);
            tenantIds.forEach(tenantId -> this.invalidateCache((String)tenantId));
        }
        this.lastRefresh = now;
    }
}

