/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.events.EventSink;
import io.apicurio.registry.events.EventsService;
import io.apicurio.registry.events.dto.RegistryEventType;
import io.quarkus.runtime.StartupEvent;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Optional;
import org.slf4j.Logger;

@ApplicationScoped
public class EventsServiceImpl
implements EventsService {
    private static final String INTERNAL_EVENTS_ADDRESS = "registry-events";
    private ObjectMapper mapper;
    private boolean configuredSinks = false;
    @Inject
    Logger log;
    @Inject
    Vertx vertx;
    @Inject
    EventBus eventBus;
    @Inject
    Instance<EventSink> sinks;

    public void init(@Observes StartupEvent ev) {
        for (EventSink sink : this.sinks) {
            if (!sink.isConfigured()) continue;
            this.log.info("Subscribing sink " + sink.name());
            this.eventBus.consumer(INTERNAL_EVENTS_ADDRESS, sink::handle);
            this.configuredSinks = true;
        }
    }

    @Override
    public boolean isConfigured() {
        return this.configuredSinks;
    }

    @Override
    public void triggerEvent(RegistryEventType type, Optional<String> artifactId, Object data) {
        if (this.configuredSinks && data != null) {
            Buffer buffer;
            try {
                buffer = Buffer.buffer((byte[])this.getMapper().writeValueAsBytes(data));
            }
            catch (JsonProcessingException e) {
                this.log.error("Error serializing event data", (Throwable)e);
                return;
            }
            DeliveryOptions opts = new DeliveryOptions().addHeader("type", type.cloudEventType());
            if (artifactId.isPresent()) {
                opts.addHeader("artifactId", artifactId.get());
            }
            this.eventBus.publish(INTERNAL_EVENTS_ADDRESS, (Object)buffer, opts);
        }
    }

    private synchronized ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return this.mapper;
    }
}

