/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ibmcompat.api;

import io.apicurio.registry.ibmcompat.api.ApiService;
import io.apicurio.registry.ibmcompat.api.impl.ApiUtil;
import io.apicurio.registry.ibmcompat.model.NewSchema;
import io.apicurio.registry.ibmcompat.model.NewSchemaVersion;
import io.apicurio.registry.ibmcompat.model.Schema;
import io.apicurio.registry.ibmcompat.model.SchemaInfo;
import io.apicurio.registry.ibmcompat.model.SchemaListItem;
import io.apicurio.registry.ibmcompat.model.SchemaModificationPatch;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;

@Path(value="/apis/ibmcompat/v1")
public class Api {
    @Inject
    ApiService service;

    @GET
    @Path(value="/schemas")
    @Produces(value={"application/json"})
    public List<SchemaListItem> apiSchemasGet(@Min(value=0L) @DefaultValue(value="0") @QueryParam(value="page") @Min(value=0L) int page, @Min(value=1L) @DefaultValue(value="100") @QueryParam(value="per_page") @Min(value=1L) int perPage) throws ArtifactNotFoundException {
        return this.service.apiSchemasGet(page, perPage);
    }

    @POST
    @Path(value="/schemas")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void apiSchemasPost(@Suspended AsyncResponse response, @NotNull @Valid NewSchema schema, @DefaultValue(value="false") @QueryParam(value="verify") boolean verify, @Context SecurityContext securityContext) throws ArtifactNotFoundException, ArtifactAlreadyExistsException {
        this.service.apiSchemasPost(response, schema, verify);
    }

    @DELETE
    @Path(value="/schemas/{schemaid}")
    @Produces(value={"application/json"})
    public Response apiSchemasSchemaidDelete(@PathParam(value="schemaid") String schemaid) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidDelete(ApiUtil.normalizeSchemaID(schemaid));
    }

    @GET
    @Path(value="/schemas/{schemaid}")
    @Produces(value={"application/json"})
    public SchemaInfo apiSchemasSchemaidGet(@PathParam(value="schemaid") String schemaid) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidGet(ApiUtil.normalizeSchemaID(schemaid));
    }

    @PATCH
    @Path(value="/schemas/{schemaid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response apiSchemasSchemaidPatch(@PathParam(value="schemaid") String schemaid, @NotNull @Valid List<SchemaModificationPatch> schemaModificationPatches) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidPatch(ApiUtil.normalizeSchemaID(schemaid), schemaModificationPatches);
    }

    @POST
    @Path(value="/schemas/{schemaid}/versions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void apiSchemasSchemaidVersionsPost(@Suspended AsyncResponse response, @PathParam(value="schemaid") @NotNull String schemaid, @NotNull @Valid NewSchemaVersion schema, @DefaultValue(value="false") @QueryParam(value="verify") boolean verify) throws ArtifactNotFoundException, ArtifactAlreadyExistsException {
        this.service.apiSchemasSchemaidVersionsPost(response, ApiUtil.normalizeSchemaID(schemaid), schema, verify);
    }

    @DELETE
    @Path(value="/schemas/{schemaid}/versions/{versionnum}")
    @Produces(value={"application/json"})
    public Response apiSchemasSchemaidVersionsVersionnumDelete(@PathParam(value="schemaid") String schemaid, @PathParam(value="versionnum") int versionnum) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidVersionsVersionnumDelete(ApiUtil.normalizeSchemaID(schemaid), versionnum);
    }

    @GET
    @Path(value="/schemas/{schemaid}/versions/{versionnum}")
    @Produces(value={"application/json", "application/vnd.apache.avro+json"})
    public Schema apiSchemasSchemaidVersionsVersionnumGet(@PathParam(value="schemaid") String schemaid, @PathParam(value="versionnum") int versionnum) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidVersionsVersionnumGet(ApiUtil.normalizeSchemaID(schemaid), versionnum);
    }

    @PATCH
    @Path(value="/schemas/{schemaid}/versions/{versionnum}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response apiSchemasSchemaidVersionsVersionnumPatch(@PathParam(value="schemaid") String schemaid, @PathParam(value="versionnum") int versionnum, @NotNull @Valid List<SchemaModificationPatch> schemaModificationPatches) throws ArtifactNotFoundException {
        return this.service.apiSchemasSchemaidVersionsVersionnumPatch(ApiUtil.normalizeSchemaID(schemaid), versionnum, schemaModificationPatches);
    }
}

