/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt.limits;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.mt.limits.LimitExceededException;
import io.apicurio.registry.mt.limits.LimitsCheckResult;
import io.apicurio.registry.mt.limits.RegistryTenantLimitsConfigurationService;
import io.apicurio.registry.mt.limits.RegistryTenantLimitsService;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.decorator.RegistryStorageDecorator;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.types.RegistryException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.eclipse.microprofile.context.ThreadContext;

@ApplicationScoped
public class RegistryStorageLimitsEnforcer
extends RegistryStorageDecorator {
    @Inject
    ThreadContext threadContext;
    @Inject
    RegistryTenantLimitsService limitsService;
    @Inject
    RegistryTenantLimitsConfigurationService limitsConfiguration;

    @Override
    public boolean isEnabled() {
        return this.limitsConfiguration.isConfigured();
    }

    @Override
    public int order() {
        return 0;
    }

    @Override
    public ArtifactMetaDataDto createArtifact(String groupId, String artifactId, String version, String artifactType, ContentHandle content, List<ArtifactReferenceDto> references) throws ArtifactAlreadyExistsException, RegistryStorageException {
        ArtifactMetaDataDto dto = this.withLimitsCheck(() -> this.limitsService.canCreateArtifact(null, content)).execute(() -> super.createArtifact(groupId, artifactId, version, artifactType, content, references));
        this.limitsService.artifactCreated();
        return dto;
    }

    @Override
    public ArtifactMetaDataDto createArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData, List<ArtifactReferenceDto> references) throws ArtifactAlreadyExistsException, RegistryStorageException {
        ArtifactMetaDataDto dto = this.withLimitsCheck(() -> this.limitsService.canCreateArtifact(metaData, content)).execute(() -> super.createArtifactWithMetadata(groupId, artifactId, version, artifactType, content, metaData, references));
        this.limitsService.artifactCreated();
        return dto;
    }

    @Override
    public ArtifactMetaDataDto updateArtifact(String groupId, String artifactId, String version, String artifactType, ContentHandle content, List<ArtifactReferenceDto> references) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactMetaDataDto dto = this.withLimitsCheck(() -> this.limitsService.canCreateArtifactVersion(groupId, artifactId, null, content)).execute(() -> super.updateArtifact(groupId, artifactId, version, artifactType, content, references));
        this.limitsService.artifactVersionCreated(groupId, artifactId);
        return dto;
    }

    @Override
    public ArtifactMetaDataDto updateArtifactWithMetadata(String groupId, String artifactId, String version, String artifactType, ContentHandle content, EditableArtifactMetaDataDto metaData, List<ArtifactReferenceDto> references) throws ArtifactNotFoundException, RegistryStorageException {
        ArtifactMetaDataDto dto = this.withLimitsCheck(() -> this.limitsService.canCreateArtifactVersion(groupId, artifactId, metaData, content)).execute(() -> super.updateArtifactWithMetadata(groupId, artifactId, version, artifactType, content, metaData, references));
        this.limitsService.artifactVersionCreated(groupId, artifactId);
        return dto;
    }

    @Override
    public void updateArtifactMetaData(String groupId, String artifactId, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, RegistryStorageException {
        this.withLimitsCheck(() -> this.limitsService.checkMetaData(metaData)).execute(() -> {
            super.updateArtifactMetaData(groupId, artifactId, metaData);
            return null;
        });
    }

    @Override
    public void updateArtifactVersionMetaData(String groupId, String artifactId, String version, EditableArtifactMetaDataDto metaData) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        this.withLimitsCheck(() -> this.limitsService.checkMetaData(metaData)).execute(() -> {
            super.updateArtifactVersionMetaData(groupId, artifactId, version, metaData);
            return null;
        });
    }

    @Override
    public List<String> deleteArtifact(String groupId, String artifactId) throws ArtifactNotFoundException, RegistryStorageException {
        List<String> ids = super.deleteArtifact(groupId, artifactId);
        this.limitsService.artifactDeleted();
        return ids;
    }

    @Override
    public void deleteArtifacts(String groupId) throws RegistryStorageException {
        super.deleteArtifacts(groupId);
        this.limitsService.artifactDeleted();
    }

    @Override
    public void deleteArtifactVersion(String groupId, String artifactId, String version) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException {
        super.deleteArtifactVersion(groupId, artifactId, version);
        this.limitsService.artifactVersionDeleted(groupId, artifactId);
    }

    @Override
    public Map<String, ContentHandle> resolveReferences(List<ArtifactReferenceDto> references) {
        return this.delegate.resolveReferences(references);
    }

    @Override
    public GroupSearchResultsDto searchGroups(Set<SearchFilter> filters, OrderBy orderBy, OrderDirection orderDirection, Integer offset, Integer limit) {
        return this.delegate.searchGroups(filters, orderBy, orderDirection, offset, limit);
    }

    public ActionProvider withLimitsCheck(final LimitsChecker checker) {
        return new ActionProvider(){

            @Override
            public <T> T execute(LimitedAction<T> action) throws RegistryException {
                LimitsCheckResult r = (LimitsCheckResult)checker.get();
                if (r.isAllowed()) {
                    Object result = action.get();
                    if (result instanceof CompletionStage) {
                        result = RegistryStorageLimitsEnforcer.this.threadContext.withContextCapture((CompletionStage)result);
                    }
                    return result;
                }
                throw new LimitExceededException(r.getMessage());
            }
        };
    }

    @FunctionalInterface
    private static interface LimitsChecker
    extends Supplier<LimitsCheckResult> {
    }

    @FunctionalInterface
    private static interface ActionProvider {
        public <T> T execute(LimitedAction<T> var1) throws RegistryException;
    }

    @FunctionalInterface
    private static interface LimitedAction<T> {
        public T get() throws RegistryException;
    }
}

