/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.common.apps.multitenancy.TenantIdResolver;
import io.apicurio.registry.services.DisabledApisMatcherService;
import io.apicurio.registry.services.http.ErrorHttpResponse;
import io.apicurio.registry.services.http.RegistryExceptionMapperService;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import org.slf4j.Logger;

@ApplicationScoped
public class RegistryApplicationServletFilter
implements Filter {
    private ObjectMapper mapper;
    @Inject
    Logger log;
    @Inject
    MultitenancyProperties mtProperties;
    @Inject
    TenantIdResolver tenantIdResolver;
    @Inject
    TenantContext tenantContext;
    @Inject
    DisabledApisMatcherService disabledApisMatcherService;
    @Inject
    RegistryExceptionMapperService exceptionMapper;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StringBuilder rewriteContext = new StringBuilder();
        HttpServletRequest req = (HttpServletRequest)request;
        String requestURI = req.getRequestURI();
        if (requestURI != null) {
            Optional tenantIdOpt;
            try {
                tenantIdOpt = this.tenantIdResolver.resolveTenantId(requestURI, arg_0 -> ((HttpServletRequest)req).getHeader(arg_0), () -> ((HttpServletRequest)req).getServerName(), tenantId -> {
                    String actualUri = requestURI.substring(this.tenantIdResolver.tenantPrefixLength(tenantId));
                    if (actualUri.length() == 0) {
                        actualUri = "/";
                    }
                    this.log.debug("tenantId[{}] Rewriting request {} to {}", new Object[]{tenantId, requestURI, actualUri});
                    rewriteContext.append(actualUri);
                });
            }
            catch (Throwable throwable) {
                this.mapException(response, throwable);
                return;
            }
            boolean rewriteRequest = tenantIdOpt.isPresent() && rewriteContext.length() != 0;
            String evaluatedURI = requestURI;
            if (rewriteRequest) {
                evaluatedURI = rewriteContext.toString();
            }
            try {
                TenantStatusValue tenantStatus = this.tenantContext.getTenantStatus();
                if (this.mtProperties.isMultitenancyEnabled() && tenantStatus != TenantStatusValue.READY) {
                    this.log.debug("Request {} is rejected because the tenant is not ready. Status is {}", (Object)requestURI, (Object)tenantStatus.value());
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    httpResponse.reset();
                    httpResponse.setStatus(404);
                    return;
                }
            }
            catch (Throwable throwable) {
                this.mapException(response, throwable);
                return;
            }
            boolean disabled = this.disabledApisMatcherService.isDisabled(evaluatedURI);
            if (disabled) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.reset();
                httpResponse.setStatus(404);
                return;
            }
            if (rewriteRequest) {
                RequestDispatcher dispatcher = req.getRequestDispatcher(rewriteContext.toString());
                dispatcher.forward((ServletRequest)req, response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void mapException(ServletResponse response, Throwable throwable) throws IOException {
        ErrorHttpResponse res = this.exceptionMapper.mapException(throwable);
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.reset();
        httpResponse.setStatus(res.getStatus());
        httpResponse.setContentType("application/json");
        this.getMapper().writeValue((OutputStream)httpResponse.getOutputStream(), (Object)res.getError());
    }

    private synchronized ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return this.mapper;
    }
}

