/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest;

import io.apicurio.registry.ccompat.rest.error.ErrorCode;
import io.apicurio.registry.ccompat.rest.error.UnprocessableEntityException;
import io.apicurio.registry.rest.v2.beans.Error;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.services.http.ErrorHttpResponse;
import io.apicurio.registry.services.http.RegistryExceptionMapperService;
import io.apicurio.registry.storage.AlreadyExistsException;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ContentNotFoundException;
import io.apicurio.registry.storage.VersionNotFoundException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

@ApplicationScoped
@Provider
public class RegistryExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Map<Class<? extends Exception>, Integer> CONFLUENT_CODE_MAP;
    @Inject
    Logger log;
    @Inject
    RegistryExceptionMapperService exceptionMapper;
    @Context
    HttpServletRequest request;

    public Response toResponse(Throwable t) {
        ErrorHttpResponse res = this.exceptionMapper.mapException(t);
        Response.ResponseBuilder builder = res.getJaxrsResponse() != null ? Response.fromResponse((Response)res.getJaxrsResponse()) : Response.status((int)res.getStatus());
        Error error = res.getError();
        if (this.isCompatEndpoint()) {
            error.setDetail(null);
            error.setName(null);
            error.setErrorCode(CONFLUENT_CODE_MAP.getOrDefault(t.getClass(), 0));
        }
        return builder.type("application/json").entity((Object)error).build();
    }

    private boolean isCompatEndpoint() {
        if (this.request != null) {
            return this.request.getRequestURI().contains("ccompat");
        }
        return false;
    }

    static {
        HashMap<Class<UnprocessableEntityException>, Integer> map = new HashMap<Class<UnprocessableEntityException>, Integer>();
        map.put(AlreadyExistsException.class, 409);
        map.put(ArtifactAlreadyExistsException.class, 409);
        map.put(ArtifactNotFoundException.class, ErrorCode.SUBJECT_NOT_FOUND.value());
        map.put(ContentNotFoundException.class, ErrorCode.SCHEMA_NOT_FOUND.value());
        map.put(RuleViolationException.class, ErrorCode.INVALID_COMPATIBILITY_LEVEL.value());
        map.put(VersionNotFoundException.class, ErrorCode.VERSION_NOT_FOUND.value());
        map.put(UnprocessableEntityException.class, ErrorCode.INVALID_SCHEMA.value());
        CONFLUENT_CODE_MAP = Collections.unmodifiableMap(map);
    }
}

