/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v1;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.Headers;
import io.apicurio.registry.rest.HeadersHack;
import io.apicurio.registry.rest.v1.IdsResource;
import io.apicurio.registry.rest.v1.V1ApiUtil;
import io.apicurio.registry.rest.v1.beans.ArtifactMetaData;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.Current;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
@Deprecated
public class IdsResourceImpl
implements IdsResource,
Headers {
    @Inject
    @Current
    RegistryStorage storage;
    @Context
    HttpServletRequest request;

    public void checkIfDeprecated(Supplier<ArtifactState> stateSupplier, String artifactId, String version, Response.ResponseBuilder builder) {
        HeadersHack.checkIfDeprecated(stateSupplier, null, artifactId, version, builder);
    }

    @Authorized(style=AuthorizedStyle.GlobalId, level=AuthorizedLevel.Read)
    public Response getArtifactByGlobalId(long globalId) {
        ArtifactMetaDataDto metaData = this.storage.getArtifactMetaData(globalId);
        if (ArtifactState.DISABLED.equals((Object)metaData.getState())) {
            throw new ArtifactNotFoundException(null, String.valueOf(globalId));
        }
        StoredArtifactDto artifact = this.storage.getArtifactVersion(globalId);
        MediaType contentType = ArtifactMediaTypes.JSON;
        if (metaData.getType() == "PROTOBUF") {
            contentType = ArtifactMediaTypes.PROTO;
        }
        Response.ResponseBuilder builder = Response.ok((Object)artifact.getContent(), (MediaType)contentType);
        this.checkIfDeprecated(metaData::getState, metaData.getId(), metaData.getVersion(), builder);
        return builder.build();
    }

    @Authorized(style=AuthorizedStyle.GlobalId, level=AuthorizedLevel.Read)
    public ArtifactMetaData getArtifactMetaDataByGlobalId(long globalId) {
        ArtifactMetaDataDto dto = this.storage.getArtifactMetaData(globalId);
        return V1ApiUtil.dtoToMetaData(dto.getId(), dto.getType(), dto);
    }
}

