/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.common.apps.config.Dynamic;
import io.apicurio.common.apps.config.DynamicConfigPropertyDef;
import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.DynamicConfigPropertyIndex;
import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.logging.Logged;
import io.apicurio.common.apps.logging.audit.Audited;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.auth.RoleBasedAccessApiOperation;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.MissingRequiredParameterException;
import io.apicurio.registry.rest.v2.AdminResource;
import io.apicurio.registry.rest.v2.beans.ArtifactTypeInfo;
import io.apicurio.registry.rest.v2.beans.ConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.DownloadRef;
import io.apicurio.registry.rest.v2.beans.LogConfiguration;
import io.apicurio.registry.rest.v2.beans.NamedLogConfiguration;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.UpdateConfigurationProperty;
import io.apicurio.registry.rest.v2.beans.UpdateRole;
import io.apicurio.registry.rest.v2.shared.DataExporter;
import io.apicurio.registry.rules.DefaultRuleDeletionException;
import io.apicurio.registry.rules.RulesProperties;
import io.apicurio.registry.services.LogConfigurationService;
import io.apicurio.registry.storage.ConfigPropertyNotFoundException;
import io.apicurio.registry.storage.InvalidPropertyValueException;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.DownloadContextType;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.impexp.EntityInputStream;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.DtoUtil;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityReader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipInputStream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class AdminResourceImpl
implements AdminResource {
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    RulesProperties rulesProperties;
    @Inject
    LogConfigurationService logConfigService;
    @Inject
    DynamicConfigPropertyIndex dynamicPropertyIndex;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Inject
    Config config;
    @Inject
    DataExporter exporter;
    @Context
    HttpServletRequest request;
    @Dynamic(label="Download link expiry", description="The number of seconds that a generated link to a .zip download file is active before expiring.")
    @ConfigProperty(name="registry.download.href.ttl", defaultValue="30")
    @Info(category="download", description="Download link expiry", availableSince="2.1.2.Final")
    Supplier<Long> downloadHrefTtl;

    private static void requireParameter(String parameterName, Object parameterValue) {
        if (parameterValue == null) {
            throw new MissingRequiredParameterException(parameterName);
        }
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<ArtifactTypeInfo> listArtifactTypes() {
        return this.factory.getAllArtifactTypes().stream().map(t -> {
            ArtifactTypeInfo ati = new ArtifactTypeInfo();
            ati.setName(t);
            return ati;
        }).collect(Collectors.toList());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public List<RuleType> listGlobalRules() {
        List<RuleType> rules = this.storage.getGlobalRules();
        List<RuleType> defaultRules = this.rulesProperties.getFilteredDefaultGlobalRules(rules);
        return Stream.concat(rules.stream(), defaultRules.stream()).sorted().collect(Collectors.toList());
    }

    @Audited(extractParameters={"0", "rule"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void createGlobalRule(Rule data) {
        RuleType type = data.getType();
        AdminResourceImpl.requireParameter("type", type);
        if (data.getConfig() == null || data.getConfig().isEmpty()) {
            throw new MissingRequiredParameterException("Config");
        }
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        this.storage.createGlobalRule(data.getType(), configDto);
    }

    @Audited
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void deleteAllGlobalRules() {
        this.storage.deleteGlobalRules();
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public Rule getGlobalRuleConfig(RuleType rule) {
        RuleConfigurationDto dto;
        block2: {
            try {
                dto = this.storage.getGlobalRule(rule);
            }
            catch (RuleNotFoundException ruleNotFoundException) {
                dto = this.rulesProperties.getDefaultGlobalRuleConfiguration(rule);
                if (dto != null) break block2;
                throw ruleNotFoundException;
            }
        }
        Rule ruleBean = new Rule();
        ruleBean.setType(rule);
        ruleBean.setConfig(dto.getConfiguration());
        return ruleBean;
    }

    @Audited(extractParameters={"0", "rule_type", "1", "rule"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public Rule updateGlobalRuleConfig(RuleType rule, Rule data) {
        RuleConfigurationDto configDto = new RuleConfigurationDto();
        configDto.setConfiguration(data.getConfig());
        try {
            this.storage.updateGlobalRule(rule, configDto);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            if (this.rulesProperties.isDefaultGlobalRuleConfigured(rule)) {
                this.storage.createGlobalRule(rule, configDto);
            }
            throw ruleNotFoundException;
        }
        Rule ruleBean = new Rule();
        ruleBean.setType(rule);
        ruleBean.setConfig(data.getConfig());
        return ruleBean;
    }

    @Audited(extractParameters={"0", "rule_type"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void deleteGlobalRule(RuleType rule) {
        try {
            this.storage.deleteGlobalRule(rule);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            if (this.rulesProperties.isDefaultGlobalRuleConfigured(rule)) {
                throw new DefaultRuleDeletionException(rule);
            }
            throw ruleNotFoundException;
        }
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public NamedLogConfiguration getLogConfiguration(String logger) {
        return this.logConfigService.getLogConfiguration(logger);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public List<NamedLogConfiguration> listLogConfigurations() {
        return this.logConfigService.listLogConfigurations();
    }

    @Audited(extractParameters={"0", "logger"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public NamedLogConfiguration removeLogConfiguration(String logger) {
        return this.logConfigService.removeLogLevelConfiguration(logger);
    }

    @Audited(extractParameters={"0", "logger", "1", "log_configuration"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public NamedLogConfiguration setLogConfiguration(String logger, LogConfiguration data) {
        if (data.getLevel() == null) {
            throw new MissingRequiredParameterException("logLevel");
        }
        return this.logConfigService.setLogLevel(logger, data.getLevel());
    }

    @Audited
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void importData(Boolean xRegistryPreserveGlobalId, Boolean xRegistryPreserveContentId, InputStream data) {
        final ZipInputStream zip = new ZipInputStream(data, StandardCharsets.UTF_8);
        final EntityReader reader = new EntityReader(zip);
        EntityInputStream stream = new EntityInputStream(){

            @Override
            public Entity nextEntity() throws IOException {
                try {
                    return reader.readEntity();
                }
                catch (Exception e) {
                    AdminResourceImpl.this.log.error("Error reading data from import ZIP file.", (Throwable)e);
                    return null;
                }
            }

            @Override
            public void close() throws IOException {
                zip.close();
            }
        };
        this.storage.importData(stream, AdminResourceImpl.isNullOrTrue(xRegistryPreserveGlobalId), AdminResourceImpl.isNullOrTrue(xRegistryPreserveContentId));
    }

    @Audited(extractParameters={"0", "for_browser"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public Response exportData(Boolean forBrowser) {
        String acceptHeader = this.request.getHeader("Accept");
        if (Boolean.TRUE.equals(forBrowser) || "application/json".equals(acceptHeader)) {
            long expires = System.currentTimeMillis() + this.downloadHrefTtl.get() * 1000L;
            DownloadContextDto downloadCtx = DownloadContextDto.builder().type(DownloadContextType.EXPORT).expires(expires).build();
            String downloadId = this.storage.createDownload(downloadCtx);
            String downloadHref = this.createDownloadHref(downloadId);
            DownloadRef downloadRef = new DownloadRef();
            downloadRef.setDownloadId(downloadId);
            downloadRef.setHref(downloadHref);
            return Response.ok((Object)downloadRef).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return this.exporter.exportData();
    }

    @Audited(extractParameters={"0", "role_mapping"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public void createRoleMapping(RoleMapping data) {
        this.storage.createRoleMapping(data.getPrincipalId(), data.getRole().name(), data.getPrincipalName());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public List<RoleMapping> listRoleMappings() {
        List<RoleMappingDto> mappings = this.storage.getRoleMappings();
        return mappings.stream().map(dto -> AdminResourceImpl.dtoToRoleMapping(dto)).collect(Collectors.toList());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public RoleMapping getRoleMapping(String principalId) {
        RoleMappingDto dto = this.storage.getRoleMapping(principalId);
        return AdminResourceImpl.dtoToRoleMapping(dto);
    }

    @Audited(extractParameters={"0", "principal_id", "1", "update_role"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public void updateRoleMapping(String principalId, UpdateRole data) {
        AdminResourceImpl.requireParameter("principalId", principalId);
        AdminResourceImpl.requireParameter("role", data.getRole());
        this.storage.updateRoleMapping(principalId, data.getRole().name());
    }

    @Audited(extractParameters={"0", "principal_id"})
    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @RoleBasedAccessApiOperation
    public void deleteRoleMapping(String principalId) {
        this.storage.deleteRoleMapping(principalId);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public List<ConfigurationProperty> listConfigProperties() {
        List props = this.storage.getConfigProperties();
        HashMap propsI = new HashMap();
        props.forEach(dto -> propsI.put(dto.getName(), dto));
        return this.dynamicPropertyIndex.getAcceptedPropertyNames().stream().sorted((pname1, pname2) -> pname1.compareTo((String)pname2)).map(pname -> propsI.containsKey(pname) ? AdminResourceImpl.dtoToConfigurationProperty(this.dynamicPropertyIndex.getProperty(pname), (DynamicConfigPropertyDto)propsI.get(pname)) : this.defToConfigurationProperty(this.dynamicPropertyIndex.getProperty(pname))).collect(Collectors.toList());
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public ConfigurationProperty getConfigProperty(String propertyName) {
        DynamicConfigPropertyDef def = this.resolveConfigProperty(propertyName);
        DynamicConfigPropertyDto dto = this.storage.getRawConfigProperty(propertyName);
        if (dto == null) {
            return this.defToConfigurationProperty(def);
        }
        return AdminResourceImpl.dtoToConfigurationProperty(def, dto);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    public void updateConfigProperty(String propertyName, UpdateConfigurationProperty data) {
        DynamicConfigPropertyDef propertyDef = this.resolveConfigProperty(propertyName);
        this.validateConfigPropertyValue(propertyDef, data.getValue());
        DynamicConfigPropertyDto dto = new DynamicConfigPropertyDto();
        dto.setName(propertyName);
        dto.setValue(data.getValue());
        this.storage.setConfigProperty(dto);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Admin)
    @Audited(extractParameters={"0", "name"})
    public void resetConfigProperty(String propertyName) {
        this.resolveConfigProperty(propertyName);
        this.storage.deleteConfigProperty(propertyName);
    }

    private static RoleMapping dtoToRoleMapping(RoleMappingDto dto) {
        RoleMapping mapping = new RoleMapping();
        mapping.setPrincipalId(dto.getPrincipalId());
        mapping.setRole(RoleType.valueOf((String)dto.getRole()));
        mapping.setPrincipalName(dto.getPrincipalName());
        return mapping;
    }

    private static boolean isNullOrTrue(Boolean value) {
        return value == null || value != false;
    }

    private String createDownloadHref(String downloadId) {
        return "/apis/registry/v2/downloads/" + downloadId;
    }

    private static ConfigurationProperty dtoToConfigurationProperty(DynamicConfigPropertyDef def, DynamicConfigPropertyDto dto) {
        ConfigurationProperty rval = new ConfigurationProperty();
        rval.setName(def.getName());
        rval.setValue(dto.getValue());
        rval.setType(def.getType().getName());
        rval.setLabel(def.getLabel());
        rval.setDescription(def.getDescription());
        return rval;
    }

    private ConfigurationProperty defToConfigurationProperty(DynamicConfigPropertyDef def) {
        String propertyValue = this.config.getOptionalValue(def.getName(), String.class).orElse(def.getDefaultValue());
        ConfigurationProperty rval = new ConfigurationProperty();
        rval.setName(DtoUtil.appAuthPropertyToRegistry(def.getName()));
        rval.setValue(propertyValue);
        rval.setType(def.getType().getName());
        rval.setLabel(def.getLabel());
        rval.setDescription(def.getDescription());
        return rval;
    }

    private DynamicConfigPropertyDef resolveConfigProperty(String propertyName) {
        DynamicConfigPropertyDef property = this.dynamicPropertyIndex.getProperty(propertyName);
        if (property == null) {
            propertyName = DtoUtil.registryAuthPropertyToApp(propertyName);
        }
        if ((property = this.dynamicPropertyIndex.getProperty(propertyName)) == null) {
            throw new ConfigPropertyNotFoundException(propertyName);
        }
        if (!this.dynamicPropertyIndex.isAccepted(propertyName)) {
            throw new ConfigPropertyNotFoundException(propertyName);
        }
        return property;
    }

    private void validateConfigPropertyValue(DynamicConfigPropertyDef propertyDef, String value) {
        if (!propertyDef.isValidValue(value)) {
            throw new InvalidPropertyValueException("Invalid dynamic configuration property value for: " + propertyDef.getName());
        }
    }
}

