/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.auth.Authorized;
import io.apicurio.registry.auth.AuthorizedLevel;
import io.apicurio.registry.auth.AuthorizedStyle;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import io.apicurio.registry.metrics.health.liveness.ResponseErrorLivenessCheck;
import io.apicurio.registry.metrics.health.readiness.ResponseTimeoutReadinessCheck;
import io.apicurio.registry.rest.v2.SearchResource;
import io.apicurio.registry.rest.v2.V2ApiUtil;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.apicurio.registry.util.ContentTypeUtil;
import io.apicurio.registry.utils.StringUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptors;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.Context;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;

@ApplicationScoped
@Interceptors(value={ResponseErrorLivenessCheck.class, ResponseTimeoutReadinessCheck.class})
@Logged
public class SearchResourceImpl
implements SearchResource {
    private static final String EMPTY_CONTENT_ERROR_MESSAGE = "Empty content is not allowed.";
    private static final String CANONICAL_QUERY_PARAM_ERROR_MESSAGE = "When setting 'canonical' to 'true', the 'artifactType' query parameter is also required.";
    @Inject
    Logger log;
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    @Context
    HttpServletRequest request;

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public ArtifactSearchResults searchArtifacts(String name, BigInteger offset, BigInteger limit, SortOrder order, SortBy orderby, List<String> labels, List<String> properties, String description, String group, Long globalId, Long contentId) {
        if (orderby == null) {
            orderby = SortBy.name;
        }
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        if (!StringUtil.isEmpty((String)name)) {
            filters.add(SearchFilter.ofName(name));
        }
        if (!StringUtil.isEmpty((String)description)) {
            filters.add(SearchFilter.ofDescription(description));
        }
        if (!StringUtil.isEmpty((String)group)) {
            filters.add(SearchFilter.ofGroup(this.gidOrNull(group)));
        }
        if (labels != null && !labels.isEmpty()) {
            labels.forEach(label -> filters.add(SearchFilter.ofLabel(label)));
        }
        if (properties != null && !properties.isEmpty()) {
            properties.stream().map(prop -> {
                String propertyValue;
                String propertyKey;
                int delimiterIndex = prop.indexOf(":");
                if (delimiterIndex == 0) {
                    throw new BadRequestException("property search filter wrong formatted, missing left side of ':' delimiter");
                }
                if (delimiterIndex == prop.length() - 1) {
                    throw new BadRequestException("property search filter wrong formatted, missing right side of ':' delimiter");
                }
                if (delimiterIndex < 0) {
                    propertyKey = prop;
                    propertyValue = null;
                } else {
                    propertyKey = prop.substring(0, delimiterIndex);
                    propertyValue = prop.substring(delimiterIndex + 1);
                }
                return SearchFilter.ofProperty(propertyKey, propertyValue);
            }).forEach(filters::add);
        }
        if (globalId != null && globalId > 0L) {
            filters.add(SearchFilter.ofGlobalId(globalId));
        }
        if (contentId != null && contentId > 0L) {
            filters.add(SearchFilter.ofContentId(contentId));
        }
        ArtifactSearchResultsDto results = this.storage.searchArtifacts(filters, oBy, oDir, offset.intValue(), limit.intValue());
        return V2ApiUtil.dtoToSearchResults(results);
    }

    @Authorized(style=AuthorizedStyle.None, level=AuthorizedLevel.Read)
    public ArtifactSearchResults searchArtifactsByContent(Boolean canonical, String artifactType, BigInteger offset, BigInteger limit, SortOrder order, SortBy orderby, InputStream data) {
        ContentHandle content;
        OrderDirection oDir;
        if (orderby == null) {
            orderby = SortBy.name;
        }
        if (offset == null) {
            offset = BigInteger.valueOf(0L);
        }
        if (limit == null) {
            limit = BigInteger.valueOf(20L);
        }
        OrderBy oBy = OrderBy.valueOf(orderby.name());
        OrderDirection orderDirection = oDir = order == null || order == SortOrder.asc ? OrderDirection.asc : OrderDirection.desc;
        if (canonical == null) {
            canonical = Boolean.FALSE;
        }
        if ((content = ContentHandle.create((InputStream)data)).bytes().length == 0) {
            throw new BadRequestException(EMPTY_CONTENT_ERROR_MESSAGE);
        }
        if (ContentTypeUtil.isApplicationYaml(this.getContentType())) {
            content = ContentTypeUtil.yamlToJson(content);
        }
        HashSet<SearchFilter> filters = new HashSet<SearchFilter>();
        if (canonical.booleanValue() && artifactType != null) {
            String canonicalHash = this.sha256Hash(this.canonicalizeContent(artifactType, content));
            filters.add(SearchFilter.ofCanonicalHash(canonicalHash));
        } else if (!canonical.booleanValue()) {
            String contentHash = this.sha256Hash(content);
            filters.add(SearchFilter.ofContentHash(contentHash));
        } else {
            throw new BadRequestException(CANONICAL_QUERY_PARAM_ERROR_MESSAGE);
        }
        ArtifactSearchResultsDto results = this.storage.searchArtifacts(filters, oBy, oDir, offset.intValue(), limit.intValue());
        return V2ApiUtil.dtoToSearchResults(results);
    }

    private String getContentType() {
        return this.request.getContentType();
    }

    private String sha256Hash(ContentHandle chandle) {
        return DigestUtils.sha256Hex((byte[])chandle.bytes());
    }

    private String gidOrNull(String groupId) {
        if ("default".equalsIgnoreCase(groupId)) {
            return null;
        }
        return groupId;
    }

    protected ContentHandle canonicalizeContent(String artifactType, ContentHandle content) {
        try {
            ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(artifactType);
            ContentCanonicalizer canonicalizer = provider.getContentCanonicalizer();
            ContentHandle canonicalContent = canonicalizer.canonicalize(content, Collections.emptyMap());
            return canonicalContent;
        }
        catch (Exception e) {
            this.log.debug("Failed to canonicalize content of type: {}", (Object)artifactType);
            return content;
        }
    }
}

