/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.common.apps.logging.Logged;
import io.apicurio.registry.rules.RuleContext;
import io.apicurio.registry.rules.RuleExecutor;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@ApplicationScoped
@Logged
public class CompatibilityRuleExecutor
implements RuleExecutor {
    @Inject
    ArtifactTypeUtilProviderFactory factory;

    @Override
    public void execute(RuleContext context) throws RuleViolationException {
        List<Object> existingArtifacts;
        CompatibilityLevel level = CompatibilityLevel.valueOf((String)context.getConfiguration());
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(context.getArtifactType());
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(level, existingArtifacts = context.getCurrentContent() != null ? context.getCurrentContent() : Collections.emptyList(), context.getUpdatedContent(), context.getResolvedReferences());
        if (!compatibilityExecutionResult.isCompatible()) {
            throw new RuleViolationException(String.format("Incompatible artifact: %s [%s], num of incompatible diffs: {%s}, list of diff types: %s", context.getArtifactId(), context.getArtifactType(), compatibilityExecutionResult.getIncompatibleDifferences().size(), this.outputReadableCompatabilityDiffs(compatibilityExecutionResult.getIncompatibleDifferences())), RuleType.COMPATIBILITY, context.getConfiguration(), this.transformCompatibilityDiffs(compatibilityExecutionResult.getIncompatibleDifferences()));
        }
    }

    private Set<RuleViolation> transformCompatibilityDiffs(Set<CompatibilityDifference> differences) {
        if (!differences.isEmpty()) {
            HashSet<RuleViolation> res = new HashSet<RuleViolation>();
            for (CompatibilityDifference diff : differences) {
                res.add(diff.asRuleViolation());
            }
            return res;
        }
        return Collections.emptySet();
    }

    private List<String> outputReadableCompatabilityDiffs(Set<CompatibilityDifference> differences) {
        if (!differences.isEmpty()) {
            ArrayList<String> res = new ArrayList<String>();
            for (CompatibilityDifference diff : differences) {
                res.add(diff.asRuleViolation().getDescription() + " at " + diff.asRuleViolation().getContext());
            }
            return res;
        }
        return new ArrayList<String>();
    }
}

