/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.DynamicConfigStorage;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.ArtifactAlreadyExistsException;
import io.apicurio.registry.storage.ArtifactNotFoundException;
import io.apicurio.registry.storage.ContentNotFoundException;
import io.apicurio.registry.storage.GroupAlreadyExistsException;
import io.apicurio.registry.storage.GroupNotFoundException;
import io.apicurio.registry.storage.LogConfigurationNotFoundException;
import io.apicurio.registry.storage.RegistryStorageException;
import io.apicurio.registry.storage.RuleAlreadyExistsException;
import io.apicurio.registry.storage.RuleNotFoundException;
import io.apicurio.registry.storage.VersionNotFoundException;
import io.apicurio.registry.storage.dto.ArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.ArtifactOwnerDto;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.storage.dto.ArtifactSearchResultsDto;
import io.apicurio.registry.storage.dto.ArtifactVersionMetaDataDto;
import io.apicurio.registry.storage.dto.CommentDto;
import io.apicurio.registry.storage.dto.ContentWrapperDto;
import io.apicurio.registry.storage.dto.DownloadContextDto;
import io.apicurio.registry.storage.dto.EditableArtifactMetaDataDto;
import io.apicurio.registry.storage.dto.GroupMetaDataDto;
import io.apicurio.registry.storage.dto.GroupSearchResultsDto;
import io.apicurio.registry.storage.dto.LogConfigurationDto;
import io.apicurio.registry.storage.dto.OrderBy;
import io.apicurio.registry.storage.dto.OrderDirection;
import io.apicurio.registry.storage.dto.RoleMappingDto;
import io.apicurio.registry.storage.dto.RuleConfigurationDto;
import io.apicurio.registry.storage.dto.SearchFilter;
import io.apicurio.registry.storage.dto.StoredArtifactDto;
import io.apicurio.registry.storage.dto.VersionSearchResultsDto;
import io.apicurio.registry.storage.impexp.EntityInputStream;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.impexp.Entity;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public interface RegistryStorage
extends DynamicConfigStorage {
    public String storageName();

    public boolean supportsMultiTenancy();

    public boolean isReady();

    public boolean isAlive();

    public void updateArtifactState(String var1, String var2, ArtifactState var3) throws ArtifactNotFoundException, RegistryStorageException;

    public void updateArtifactState(String var1, String var2, String var3, ArtifactState var4) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public ArtifactMetaDataDto createArtifact(String var1, String var2, String var3, String var4, ContentHandle var5, List<ArtifactReferenceDto> var6) throws ArtifactAlreadyExistsException, RegistryStorageException;

    public ArtifactMetaDataDto createArtifactWithMetadata(String var1, String var2, String var3, String var4, ContentHandle var5, EditableArtifactMetaDataDto var6, List<ArtifactReferenceDto> var7) throws ArtifactAlreadyExistsException, RegistryStorageException;

    public List<String> deleteArtifact(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public void deleteArtifacts(String var1) throws RegistryStorageException;

    public StoredArtifactDto getArtifact(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public StoredArtifactDto getArtifact(String var1, String var2, ArtifactRetrievalBehavior var3) throws ArtifactNotFoundException, RegistryStorageException;

    public ContentWrapperDto getArtifactByContentId(long var1) throws ContentNotFoundException, RegistryStorageException;

    public ContentWrapperDto getArtifactByContentHash(String var1) throws ContentNotFoundException, RegistryStorageException;

    public List<ArtifactMetaDataDto> getArtifactVersionsByContentId(long var1);

    public List<Long> getArtifactContentIds(String var1, String var2);

    public ArtifactMetaDataDto updateArtifact(String var1, String var2, String var3, String var4, ContentHandle var5, List<ArtifactReferenceDto> var6) throws ArtifactNotFoundException, RegistryStorageException;

    public ArtifactMetaDataDto updateArtifactWithMetadata(String var1, String var2, String var3, String var4, ContentHandle var5, EditableArtifactMetaDataDto var6, List<ArtifactReferenceDto> var7) throws ArtifactNotFoundException, RegistryStorageException;

    public Set<String> getArtifactIds(Integer var1);

    public ArtifactSearchResultsDto searchArtifacts(Set<SearchFilter> var1, OrderBy var2, OrderDirection var3, int var4, int var5);

    public ArtifactMetaDataDto getArtifactMetaData(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public ArtifactMetaDataDto getArtifactMetaData(String var1, String var2, ArtifactRetrievalBehavior var3) throws ArtifactNotFoundException, RegistryStorageException;

    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String var1, String var2, boolean var3, ContentHandle var4, List<ArtifactReferenceDto> var5) throws ArtifactNotFoundException, RegistryStorageException;

    public ArtifactMetaDataDto getArtifactMetaData(long var1) throws ArtifactNotFoundException, RegistryStorageException;

    public void updateArtifactMetaData(String var1, String var2, EditableArtifactMetaDataDto var3) throws ArtifactNotFoundException, RegistryStorageException;

    public void updateArtifactOwner(String var1, String var2, ArtifactOwnerDto var3) throws ArtifactNotFoundException, RegistryStorageException;

    public List<RuleType> getArtifactRules(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public void createArtifactRule(String var1, String var2, RuleType var3, RuleConfigurationDto var4) throws ArtifactNotFoundException, RuleAlreadyExistsException, RegistryStorageException;

    public void deleteArtifactRules(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public RuleConfigurationDto getArtifactRule(String var1, String var2, RuleType var3) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException;

    public void updateArtifactRule(String var1, String var2, RuleType var3, RuleConfigurationDto var4) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException;

    public void deleteArtifactRule(String var1, String var2, RuleType var3) throws ArtifactNotFoundException, RuleNotFoundException, RegistryStorageException;

    public List<String> getArtifactVersions(String var1, String var2) throws ArtifactNotFoundException, RegistryStorageException;

    public VersionSearchResultsDto searchVersions(String var1, String var2, int var3, int var4) throws ArtifactNotFoundException, RegistryStorageException;

    public StoredArtifactDto getArtifactVersion(long var1) throws ArtifactNotFoundException, RegistryStorageException;

    public StoredArtifactDto getArtifactVersion(String var1, String var2, String var3) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public void deleteArtifactVersion(String var1, String var2, String var3) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public ArtifactVersionMetaDataDto getArtifactVersionMetaData(String var1, String var2, String var3) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public void updateArtifactVersionMetaData(String var1, String var2, String var3, EditableArtifactMetaDataDto var4) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public void deleteArtifactVersionMetaData(String var1, String var2, String var3) throws ArtifactNotFoundException, VersionNotFoundException, RegistryStorageException;

    public List<RuleType> getGlobalRules() throws RegistryStorageException;

    public void createGlobalRule(RuleType var1, RuleConfigurationDto var2) throws RuleAlreadyExistsException, RegistryStorageException;

    public void deleteGlobalRules() throws RegistryStorageException;

    public RuleConfigurationDto getGlobalRule(RuleType var1) throws RuleNotFoundException, RegistryStorageException;

    public void updateGlobalRule(RuleType var1, RuleConfigurationDto var2) throws RuleNotFoundException, RegistryStorageException;

    public void deleteGlobalRule(RuleType var1) throws RuleNotFoundException, RegistryStorageException;

    public LogConfigurationDto getLogConfiguration(String var1) throws RegistryStorageException, LogConfigurationNotFoundException;

    public void setLogConfiguration(LogConfigurationDto var1) throws RegistryStorageException;

    public void removeLogConfiguration(String var1) throws RegistryStorageException, LogConfigurationNotFoundException;

    public List<LogConfigurationDto> listLogConfigurations() throws RegistryStorageException;

    public void createGroup(GroupMetaDataDto var1) throws GroupAlreadyExistsException, RegistryStorageException;

    public void updateGroupMetaData(GroupMetaDataDto var1) throws GroupNotFoundException, RegistryStorageException;

    public void deleteGroup(String var1) throws GroupNotFoundException, RegistryStorageException;

    public List<String> getGroupIds(Integer var1) throws RegistryStorageException;

    public GroupMetaDataDto getGroupMetaData(String var1) throws GroupNotFoundException, RegistryStorageException;

    public void exportData(Function<Entity, Void> var1) throws RegistryStorageException;

    public void importData(EntityInputStream var1, boolean var2, boolean var3) throws RegistryStorageException;

    public long countArtifacts() throws RegistryStorageException;

    public long countArtifactVersions(String var1, String var2) throws RegistryStorageException;

    public long countTotalArtifactVersions() throws RegistryStorageException;

    public void createRoleMapping(String var1, String var2, String var3) throws RegistryStorageException;

    public List<RoleMappingDto> getRoleMappings() throws RegistryStorageException;

    public RoleMappingDto getRoleMapping(String var1) throws RegistryStorageException;

    public String getRoleForPrincipal(String var1) throws RegistryStorageException;

    public void updateRoleMapping(String var1, String var2) throws RegistryStorageException;

    public void deleteRoleMapping(String var1) throws RegistryStorageException;

    public void deleteAllUserData();

    public String createDownload(DownloadContextDto var1) throws RegistryStorageException;

    public DownloadContextDto consumeDownload(String var1) throws RegistryStorageException;

    public void deleteAllExpiredDownloads() throws RegistryStorageException;

    public DynamicConfigPropertyDto getRawConfigProperty(String var1);

    public List<String> getTenantsWithStaleConfigProperties(Instant var1);

    public Map<String, ContentHandle> resolveReferences(List<ArtifactReferenceDto> var1);

    public boolean isArtifactExists(String var1, String var2) throws RegistryStorageException;

    public boolean isGroupExists(String var1) throws RegistryStorageException;

    public List<Long> getContentIdsReferencingArtifact(String var1, String var2, String var3);

    public List<Long> getGlobalIdsReferencingArtifact(String var1, String var2, String var3);

    public List<ArtifactReferenceDto> getInboundArtifactReferences(String var1, String var2, String var3);

    public boolean isArtifactVersionExists(String var1, String var2, String var3) throws RegistryStorageException;

    public GroupSearchResultsDto searchGroups(Set<SearchFilter> var1, OrderBy var2, OrderDirection var3, Integer var4, Integer var5);

    public CommentDto createArtifactVersionComment(String var1, String var2, String var3, String var4);

    public void deleteArtifactVersionComment(String var1, String var2, String var3, String var4);

    public List<CommentDto> getArtifactVersionComments(String var1, String var2, String var3);

    public void updateArtifactVersionComment(String var1, String var2, String var3, String var4, String var5);

    public static enum ArtifactRetrievalBehavior {
        DEFAULT,
        SKIP_DISABLED_LATEST;

    }
}

