/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import io.apicurio.registry.storage.impl.sql.CommonSqlStatements;

public class H2SqlStatements
extends CommonSqlStatements {
    @Override
    public String dbType() {
        return "h2";
    }

    @Override
    public boolean isPrimaryKeyViolation(Exception error) {
        return error.getMessage() != null && error.getMessage().contains("primary key violation");
    }

    @Override
    public boolean isForeignKeyViolation(Exception error) {
        return error.getMessage() != null && error.getMessage().contains("Referential integrity constraint violation");
    }

    @Override
    public String isDatabaseInitialized() {
        return "SELECT COUNT(*) AS count FROM information_schema.tables WHERE table_name = 'APICURIO'";
    }

    @Override
    public String upsertContent() {
        return "INSERT INTO content (tenantId, contentId, canonicalHash, contentHash, content, artifactreferences) VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public String upsertLogConfiguration() {
        return "MERGE INTO logconfiguration (logger, loglevel) KEY (logger) VALUES(?, ?)";
    }

    @Override
    public String getNextSequenceValue() {
        return "UPDATE sequences sa SET seq_value = (SELECT sb.seq_value + 1 FROM sequences sb WHERE sb.tenantId = sa.tenantId AND sb.name = sa.name) WHERE sa.tenantId = ? AND sa.name = ?";
    }

    @Override
    public String selectCurrentSequenceValue() {
        return "SELECT seq_value FROM sequences WHERE name = ? AND tenantId = ? ";
    }

    @Override
    public String resetSequenceValue() {
        return "MERGE INTO sequences (tenantId, name, seq_value) KEY (tenantId, name) VALUES(?, ?, ?)";
    }

    @Override
    public String insertSequenceValue() {
        return "INSERT INTO sequences (tenantId, name, seq_value) VALUES (?, ?, ?)";
    }

    @Override
    public String upsertReference() {
        return "INSERT INTO artifactreferences (tenantId, contentId, groupId, artifactId, version, name) VALUES (?, ?, ?, ?, ?, ?)";
    }
}

