/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.utils.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SqlUtil {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String NULL_GROUP_ID = "__$GROUPID$__";

    public static String serializeLabels(List<String> labels) {
        try {
            if (labels == null) {
                return null;
            }
            if (labels.isEmpty()) {
                return null;
            }
            return mapper.writeValueAsString(labels);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> deserializeLabels(String labelsStr) {
        try {
            if (StringUtil.isEmpty((String)labelsStr)) {
                return null;
            }
            return (List)mapper.readValue(labelsStr, List.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String serializeProperties(Map<String, String> properties) {
        try {
            if (properties == null) {
                return null;
            }
            if (properties.isEmpty()) {
                return null;
            }
            return mapper.writeValueAsString(properties);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> deserializeProperties(String propertiesStr) {
        try {
            if (StringUtil.isEmpty((String)propertiesStr)) {
                return null;
            }
            return (Map)mapper.readValue(propertiesStr, Map.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String serializeReferences(List<ArtifactReferenceDto> references) {
        try {
            if (references == null || references.isEmpty()) {
                return null;
            }
            return mapper.writeValueAsString(references);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<ArtifactReferenceDto> deserializeReferences(String references) {
        try {
            if (StringUtil.isEmpty((String)references)) {
                return Collections.emptyList();
            }
            return (List)mapper.readValue(references, (TypeReference)new TypeReference<List<ArtifactReferenceDto>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String normalizeGroupId(String groupId) {
        if (groupId == null) {
            return NULL_GROUP_ID;
        }
        return groupId;
    }

    public static String denormalizeGroupId(String groupId) {
        if (NULL_GROUP_ID.equals(groupId)) {
            return null;
        }
        return groupId;
    }
}

