/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql.jdb;

import io.apicurio.registry.storage.impl.sql.jdb.MappedQuery;
import io.apicurio.registry.storage.impl.sql.jdb.RowMapper;
import io.apicurio.registry.storage.impl.sql.jdb.RuntimeSqlException;
import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MappedQueryImpl<T>
implements MappedQuery<T>,
Closeable {
    final PreparedStatement statement;
    final RowMapper<T> mapper;
    final ResultSet resultSet;

    public MappedQueryImpl(PreparedStatement statement, RowMapper<T> mapper) throws SQLException {
        this.statement = statement;
        this.mapper = mapper;
        this.resultSet = statement.executeQuery();
    }

    @Override
    public T one() {
        T rval;
        block7: {
            rval = null;
            try {
                if (this.resultSet.next()) {
                    rval = this.mapper.map(this.resultSet);
                    if (this.resultSet.next()) {
                        throw new RuntimeSqlException("SQL error: Expected only one result but got multiple.");
                    }
                    break block7;
                }
                throw new RuntimeSqlException("SQL error: Expected only one result row but got none.");
            }
            catch (SQLException e) {
                throw new RuntimeSqlException(e);
            }
            finally {
                this.close();
            }
        }
        return rval;
    }

    @Override
    public T first() {
        T rval;
        block6: {
            rval = null;
            try {
                if (this.resultSet.next()) {
                    rval = this.mapper.map(this.resultSet);
                    break block6;
                }
                throw new RuntimeSqlException("SQL error: Expected AT LEAST one result row but got none.");
            }
            catch (SQLException e) {
                throw new RuntimeSqlException(e);
            }
            finally {
                this.close();
            }
        }
        return rval;
    }

    @Override
    public Optional<T> findOne() {
        Optional rval;
        try {
            if (this.resultSet.next()) {
                rval = Optional.of(this.mapper.map(this.resultSet));
                if (this.resultSet.next()) {
                    throw new RuntimeSqlException("SQL error: Expected only one result but got multiple.");
                }
            } else {
                rval = Optional.empty();
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        finally {
            this.close();
        }
        return rval;
    }

    @Override
    public Optional<T> findFirst() {
        Optional rval = null;
        try {
            rval = this.resultSet.next() ? Optional.of(this.mapper.map(this.resultSet)) : Optional.empty();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        finally {
            this.close();
        }
        return rval;
    }

    @Override
    public Optional<T> findLast() {
        Optional rval = null;
        try {
            while (this.resultSet.next()) {
                rval = Optional.of(this.mapper.map(this.resultSet));
            }
            if (rval == null) {
                rval = Optional.empty();
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        finally {
            this.close();
        }
        return rval;
    }

    @Override
    public List<T> list() {
        LinkedList<T> rval = new LinkedList<T>();
        try {
            while (this.resultSet.next()) {
                T t = this.mapper.map(this.resultSet);
                rval.add(t);
            }
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
        finally {
            this.close();
        }
        return rval;
    }

    @Override
    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1297){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                try {
                    if (!MappedQueryImpl.this.resultSet.next()) {
                        return false;
                    }
                    Object t = MappedQueryImpl.this.mapper.map(MappedQueryImpl.this.resultSet);
                    action.accept(t);
                    return true;
                }
                catch (SQLException e) {
                    throw new RuntimeSqlException(e);
                }
            }
        }, false).onClose(this::close);
    }

    @Override
    public void close() {
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }
}

