/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql.jdb;

import io.apicurio.registry.storage.impl.sql.jdb.MappedQuery;
import io.apicurio.registry.storage.impl.sql.jdb.MappedQueryImpl;
import io.apicurio.registry.storage.impl.sql.jdb.Query;
import io.apicurio.registry.storage.impl.sql.jdb.RowMapper;
import io.apicurio.registry.storage.impl.sql.jdb.RuntimeSqlException;
import io.apicurio.registry.storage.impl.sql.jdb.SqlImpl;
import io.apicurio.registry.storage.impl.sql.mappers.IntegerMapper;
import io.apicurio.registry.storage.impl.sql.mappers.LongMapper;
import io.apicurio.registry.storage.impl.sql.mappers.StringMapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class QueryImpl
extends SqlImpl<Query>
implements Query {
    private int fetchSize = -1;

    public QueryImpl(Connection connection, String sql) {
        super(connection, sql);
    }

    @Override
    public Query setFetchSize(int size) {
        this.fetchSize = size;
        return this;
    }

    @Override
    public <T> MappedQuery<T> map(RowMapper<T> mapper) {
        try {
            PreparedStatement statement = this.connection.prepareStatement(this.sql);
            this.bindParametersTo(statement);
            if (this.fetchSize != -1) {
                statement.setFetchSize(this.fetchSize);
            }
            return new MappedQueryImpl<T>(statement, mapper);
        }
        catch (SQLException e) {
            throw new RuntimeSqlException(e);
        }
    }

    @Override
    public <T> MappedQuery<T> mapTo(Class<T> someClass) {
        RowMapper<T> mapper = this.createMapper(someClass);
        return this.map(mapper);
    }

    private <T> RowMapper<T> createMapper(Class<T> someClass) {
        if (someClass == Long.class) {
            return LongMapper.instance;
        }
        if (someClass == Integer.class) {
            return IntegerMapper.instance;
        }
        if (someClass == String.class) {
            return StringMapper.instance;
        }
        throw new RuntimeSqlException("Row mapper not implemented for class: " + someClass);
    }
}

