/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.storage.impl.sql.upgrader;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.canon.ProtobufContentCanonicalizer;
import io.apicurio.registry.storage.impl.sql.IDbUpgrader;
import io.apicurio.registry.storage.impl.sql.jdb.Handle;
import io.apicurio.registry.storage.impl.sql.jdb.Query;
import io.apicurio.registry.storage.impl.sql.jdb.Update;
import io.apicurio.registry.storage.impl.sql.mappers.ContentEntityMapper;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RegisterForReflection
public class ProtobufCanonicalHashUpgrader
implements IDbUpgrader {
    private static Logger logger = LoggerFactory.getLogger(ProtobufCanonicalHashUpgrader.class);

    @Override
    public void upgrade(Handle dbHandle) throws Exception {
        Stream<ContentEntity> stream;
        String sql = "SELECT c.contentId, c.content, c.canonicalHash, c.contentHash FROM versions v JOIN content c on c.contentId = v.contentId JOIN artifacts a ON v.tenantId = a.tenantId AND v.groupId = a.groupId AND v.artifactId = a.artifactId WHERE a.type = ?";
        try (Stream<ContentEntity> stream2 = stream = ((Query)dbHandle.createQuery(sql).setFetchSize(50).bind(0, "PROTOBUF")).map(ContentEntityMapper.instance).stream();){
            stream.forEach(entity -> this.updateCanonicalHash((ContentEntity)entity, dbHandle));
        }
    }

    private void updateCanonicalHash(ContentEntity contentEntity, Handle dbHandle) {
        ContentHandle canonicalContent = this.canonicalizeContent(ContentHandle.create((byte[])contentEntity.contentBytes));
        byte[] canonicalContentBytes = canonicalContent.bytes();
        String canonicalContentHash = DigestUtils.sha256Hex((byte[])canonicalContentBytes);
        String update = "UPDATE content SET canonicalHash = ? WHERE contentId = ? AND contentHash = ?";
        int rowCount = ((Update)((Update)((Update)dbHandle.createUpdate(update).bind(0, canonicalContentHash)).bind(1, contentEntity.contentId)).bind(2, contentEntity.contentHash)).execute();
        if (rowCount == 0) {
            logger.warn("content row not matched for canonical hash upgrade contentId {} contentHash {}", (Object)contentEntity.contentId, (Object)contentEntity.contentHash);
        }
    }

    private ContentHandle canonicalizeContent(ContentHandle content) {
        try {
            ProtobufContentCanonicalizer canonicalizer = new ProtobufContentCanonicalizer();
            ContentHandle canonicalContent = canonicalizer.canonicalize(content, Collections.emptyMap());
            return canonicalContent;
        }
        catch (Exception e) {
            logger.debug("Failed to canonicalize content of type: {}", (Object)"PROTOBUF");
            return content;
        }
    }
}

