/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ui.servlets;

import io.apicurio.common.apps.config.Info;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class BaseHrefFilter
implements Filter {
    @ConfigProperty(name="registry.ui.root")
    @Info(category="ui", description="Overrides the UI root context (useful when relocating the UI context using an inbound proxy)", availableSince="2.3.0.Final")
    String uiRoot;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CharResponseWrapper wrappedResponse = new CharResponseWrapper((HttpServletResponse)response);
        chain.doFilter(request, (ServletResponse)wrappedResponse);
        byte[] bytes = wrappedResponse.getByteArray();
        if (bytes != null && response.getContentType() != null && response.getContentType().contains("text/html")) {
            String out = new String(bytes, StandardCharsets.UTF_8);
            out = out.replace("<base href=\"/\">", "<base href=\"" + this.uiRoot + "\">");
            byte[] newBytes = out.getBytes(StandardCharsets.UTF_8);
            response.setContentLength(newBytes.length);
            response.getOutputStream().write(newBytes);
        } else if (bytes != null && bytes.length > 0) {
            response.getOutputStream().write(bytes);
        }
    }

    public void destroy() {
    }

    public class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayPrintWriter output;
        private boolean usingWriter;

        public CharResponseWrapper(HttpServletResponse response) {
            super(response);
            this.usingWriter = false;
            this.output = new ByteArrayPrintWriter();
        }

        public byte[] getByteArray() {
            return this.output.toByteArray();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.usingWriter) {
                super.getOutputStream();
            }
            this.usingWriter = true;
            return this.output.getStream();
        }

        public PrintWriter getWriter() throws IOException {
            if (this.usingWriter) {
                super.getWriter();
            }
            this.usingWriter = true;
            return this.output.getWriter();
        }

        public String toString() {
            return this.output.toString();
        }
    }

    private static class ByteArrayPrintWriter {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private PrintWriter pw = new PrintWriter(this.baos);
        private ServletOutputStream sos = new ByteArrayServletStream(this.baos);

        private ByteArrayPrintWriter() {
        }

        public PrintWriter getWriter() {
            return this.pw;
        }

        public ServletOutputStream getStream() {
            return this.sos;
        }

        byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }

    private static class ByteArrayServletStream
    extends ServletOutputStream {
        ByteArrayOutputStream baos;

        ByteArrayServletStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int param) throws IOException {
            this.baos.write(param);
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

