/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.DescriptorProtos;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.storage.InvalidArtifactTypeException;
import io.apicurio.registry.util.DocumentBuilderAccessor;
import io.apicurio.registry.utils.protobuf.schema.FileDescriptorUtils;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import jakarta.ws.rs.BadRequestException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ArtifactTypeUtil {
    private static final Pattern QUOTED_BRACKETS = Pattern.compile(": *\"\\{}\"");
    private static final ObjectMapper mapper = new ObjectMapper();

    private ArtifactTypeUtil() {
    }

    public static String determineArtifactType(ContentHandle content, String xArtifactType, String contentType, List<String> availableTypes) {
        return ArtifactTypeUtil.determineArtifactType(content, xArtifactType, contentType, Collections.emptyMap(), availableTypes);
    }

    public static String determineArtifactType(ContentHandle content, String xArtifactType, String contentType, Map<String, ContentHandle> resolvedReferences, List<String> availableTypes) {
        String artifactType = xArtifactType;
        if (artifactType == null && (artifactType = ArtifactTypeUtil.getArtifactTypeFromContentType(contentType, availableTypes)) == null) {
            artifactType = ArtifactTypeUtil.discoverType(content, contentType, resolvedReferences);
        }
        return artifactType;
    }

    private static String getArtifactTypeFromContentType(String contentType, List<String> availableTypes) {
        String[] split;
        if (contentType != null && contentType.contains("application/json") && contentType.indexOf(59) != -1 && (split = contentType.split(";")).length > 1) {
            for (String s : split) {
                if (!s.contains("artifactType=")) continue;
                String at = s.split("=")[1];
                for (String t : availableTypes) {
                    if (!t.equals(at)) continue;
                    return at;
                }
                throw new BadRequestException("Unsupported artifact type: " + at);
            }
        }
        if (contentType != null && contentType.contains("x-proto")) {
            return "PROTOBUF";
        }
        if (contentType != null && contentType.contains("graphql")) {
            return "GRAPHQL";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String discoverType(ContentHandle content, String contentType, Map<String, ContentHandle> resolvedReferences) throws InvalidArtifactTypeException {
        boolean triedProto = false;
        if (contentType == null || contentType.toLowerCase().contains("proto")) {
            triedProto = true;
            String type = ArtifactTypeUtil.tryProto(content);
            if (type != null) {
                return type;
            }
        }
        try {
            JsonNode tree = mapper.readTree(content.content());
            if (tree.has("openapi")) return "OPENAPI";
            if (tree.has("swagger")) {
                return "OPENAPI";
            }
            if (tree.has("asyncapi")) {
                return "ASYNCAPI";
            }
            if (tree.has("$schema")) {
                if (tree.get("$schema").asText().contains("json-schema.org")) return "JSON";
            }
            if (!tree.has("properties")) throw new InvalidArtifactTypeException("Failed to discover artifact type from JSON content.");
            return "JSON";
        }
        catch (Exception tree) {
            try {
                Schema.Parser parser = new Schema.Parser();
                ArrayList<Schema> schemaRefs = new ArrayList<Schema>();
                Iterator<Map.Entry<String, ContentHandle>> iterator = resolvedReferences.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        Schema schema = parser.parse(ArtifactTypeUtil.removeQuotedBrackets(content.content()));
                        schema.toString(schemaRefs, false);
                        return "AVRO";
                    }
                    Map.Entry<String, ContentHandle> referencedContent = iterator.next();
                    if (parser.getTypes().containsKey(referencedContent.getKey())) continue;
                    Schema schemaRef = parser.parse(referencedContent.getValue().content());
                    schemaRefs.add(schemaRef);
                }
            }
            catch (Exception parser) {
                try {
                    Schema.Parser parser2 = new Schema.Parser();
                    ArrayList<Schema> schemaRefs = new ArrayList<Schema>();
                    Schema schema = resolvedReferences.entrySet().iterator();
                    while (true) {
                        if (!schema.hasNext()) {
                            schema = parser2.parse(content.content());
                            schema.toString(schemaRefs, false);
                            return "AVRO";
                        }
                        Map.Entry<String, ContentHandle> referencedContent = schema.next();
                        if (parser2.getTypes().containsKey(referencedContent.getKey())) continue;
                        Schema schemaRef = parser2.parse(referencedContent.getValue().content());
                        schemaRefs.add(schemaRef);
                    }
                }
                catch (Exception parser2) {
                    String type;
                    if (!triedProto && (type = ArtifactTypeUtil.tryProto(content)) != null) {
                        return type;
                    }
                    if (ArtifactTypeUtil.tryGraphQL(content)) {
                        return "GRAPHQL";
                    }
                    try (InputStream stream = content.stream();){
                        Document xmlDocument = DocumentBuilderAccessor.getDocumentBuilder().parse(stream);
                        Element root = xmlDocument.getDocumentElement();
                        String ns = root.getNamespaceURI();
                        if (ns != null && ns.equals("http://www.w3.org/2001/XMLSchema")) {
                            String string = "XSD";
                            return string;
                        }
                        if (ns != null && (ns.equals("http://schemas.xmlsoap.org/wsdl/") || ns.equals("http://www.w3.org/ns/wsdl/"))) {
                            String string = "WSDL";
                            return string;
                        }
                        String string = "XML";
                        return string;
                    }
                    catch (Exception exception) {
                        throw new InvalidArtifactTypeException("Failed to discover artifact type from content.");
                    }
                }
            }
        }
    }

    private static String tryProto(ContentHandle content) {
        try {
            ProtobufFile.toProtoFileElement((String)content.content());
            return "PROTOBUF";
        }
        catch (Exception e) {
            try {
                byte[] bytes = Base64.getDecoder().decode(content.content());
                FileDescriptorUtils.fileDescriptorToProtoFile((DescriptorProtos.FileDescriptorProto)DescriptorProtos.FileDescriptorProto.parseFrom((byte[])bytes));
                return "PROTOBUF";
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static String removeQuotedBrackets(String content) {
        return QUOTED_BRACKETS.matcher(content).replaceAll(":{}");
    }

    private static boolean tryGraphQL(ContentHandle content) {
        try {
            TypeDefinitionRegistry typeRegistry = new SchemaParser().parse(content.content());
            if (typeRegistry != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

