/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.config.impl;

import io.apicurio.common.apps.config.DynamicConfigPropertyDto;
import io.apicurio.common.apps.config.DynamicConfigStorage;
import io.apicurio.common.apps.config.impl.DynamicConfigPropertyIndexImpl;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConfigSource
implements ConfigSource {
    private static final String LOG_PREFIX = "Could not get dynamic configuration value for {} in thread {}. ";
    private static final Logger log = LoggerFactory.getLogger(DynamicConfigSource.class);
    private static Optional<DynamicConfigStorage> storage = Optional.empty();
    private static Optional<DynamicConfigPropertyIndexImpl> configIndex = Optional.empty();

    public static void setStorage(DynamicConfigStorage configStorage) {
        storage = Optional.of(configStorage);
    }

    public static void setConfigurationIndex(DynamicConfigPropertyIndexImpl index) {
        configIndex = Optional.of(index);
    }

    public int getOrdinal() {
        return 450;
    }

    public Set<String> getPropertyNames() {
        return Collections.emptySet();
    }

    public String getValue(String propertyName) {
        String pname = this.normalizePropertyName(propertyName);
        if (configIndex.isPresent() && configIndex.get().hasProperty(pname)) {
            if (storage.isPresent()) {
                if (storage.get().isReady()) {
                    DynamicConfigPropertyDto dto = storage.get().getConfigProperty(pname);
                    if (dto != null) {
                        log.debug("Got dynamic configuration value {} for {} in thread {}", new Object[]{dto.getValue(), pname, Thread.currentThread().getName()});
                        return dto.getValue();
                    }
                    log.debug("Could not get dynamic configuration value for {} in thread {}. Storage returned null.", (Object)pname, (Object)Thread.currentThread().getName());
                } else {
                    log.debug("Could not get dynamic configuration value for {} in thread {}. Storage is not ready.", (Object)pname, (Object)Thread.currentThread().getName());
                }
            } else {
                log.debug("Could not get dynamic configuration value for {} in thread {}. Storage is not present.", (Object)pname, (Object)Thread.currentThread().getName());
            }
        }
        return null;
    }

    private String normalizePropertyName(String propertyName) {
        if (propertyName == null || !propertyName.startsWith("%")) {
            return propertyName;
        }
        int idx = propertyName.indexOf(".");
        if (idx >= propertyName.length()) {
            return propertyName;
        }
        return propertyName.substring(idx + 1);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

