/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.deref;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.paths.NodePath;
import io.apicurio.datamodels.paths.NodePathUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public abstract class ReferencedNodeImporter
extends CombinedVisitorAdapter {
    private final Document doc;
    private final Node nodeWithUnresolvedRef;
    private final String ref;
    private final boolean _shouldInline;
    private Node importedNode;
    private String pathToImportedNode;

    public ReferencedNodeImporter(Document doc, Node nodeWithUnresolvedRef, String ref, boolean shouldInline) {
        this.doc = doc;
        this.nodeWithUnresolvedRef = nodeWithUnresolvedRef;
        this.ref = ref;
        this._shouldInline = shouldInline;
    }

    public Node getImportedNode() {
        return this.importedNode;
    }

    public String getPathToImportedNode() {
        return this.pathToImportedNode;
    }

    protected Document getDoc() {
        return this.doc;
    }

    protected Node getNodeWithUnresolvedRef() {
        return this.nodeWithUnresolvedRef;
    }

    protected String getRef() {
        return this.ref;
    }

    public boolean shouldInline() {
        return this._shouldInline;
    }

    public String getNameHintFromRef(String defaultHint) {
        int idx = this.ref.lastIndexOf(47);
        if (idx > 0) {
            return this.ref.substring(idx + 1);
        }
        return defaultHint;
    }

    public void importNode(Node resolvedNode) {
        resolvedNode.accept(this);
    }

    public void setPathToImportedNode(Node importedNode, String pathToImportedNode) {
        this.importedNode = importedNode;
        this.pathToImportedNode = pathToImportedNode;
    }

    protected String generateNodeName(String nameHint, Collection<String> existingNames) {
        if (!existingNames.contains(nameHint)) {
            return nameHint;
        }
        int counter = 1;
        while (existingNames.contains(nameHint + counter)) {
            ++counter;
        }
        return nameHint + counter;
    }

    protected Collection<String> getComponentNames(Map<String, ?> components) {
        if (components == null) {
            return new HashSet<String>();
        }
        return components.keySet();
    }

    protected String getComponentName(Node nodeWithUnresolvedRef) {
        NodePath nodePath = NodePathUtil.createNodePath(this.getNodeWithUnresolvedRef());
        return nodePath.getLastSegment().getValue();
    }

    protected void inlineComponent(String componentType, Node node) {
        ObjectNode json = Library.writeNode(node);
        Library.readNode(json, this.getNodeWithUnresolvedRef());
        this.setPathToImportedNode(this.getNodeWithUnresolvedRef(), componentType, this.getComponentName(this.getNodeWithUnresolvedRef()));
    }

    protected abstract void setPathToImportedNode(Node var1, String var2, String var3);
}

