/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.util;

import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.validation.ValidationVisitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public class ValidationUtil {
    public static final ValidationVisitor createValidationVisitorForNode(Node node) {
        return new ValidationVisitor(node.root().modelType());
    }

    public static final ValidationVisitor createValidationVisitor(ModelType type) {
        return new ValidationVisitor(type);
    }

    public static ValidationRule instantiate(ValidationRuleMetaData ruleInfo) {
        try {
            Constructor<?> constructor = ruleInfo.ruleClass.getConstructor(ValidationRuleMetaData.class);
            return (ValidationRule)constructor.newInstance(ruleInfo);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static String join(String delim, List<String> values) {
        return String.join((CharSequence)delim, values);
    }

    public static String joinArray(String delim, String[] values) {
        return ValidationUtil.join(delim, Arrays.asList(values));
    }
}

