/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.impexp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.impexp.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.CommentEntity;
import io.apicurio.registry.utils.impexp.ContentEntity;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityType;
import io.apicurio.registry.utils.impexp.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.GroupEntity;
import io.apicurio.registry.utils.impexp.ManifestEntity;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class EntityReader {
    private static final ObjectMapper mapper;
    private final transient ZipInputStream zip;

    public EntityReader(ZipInputStream zip) {
        this.zip = zip;
    }

    public Entity readEntity() throws IOException {
        String path;
        EntityType entityType;
        ZipEntry entry = this.zip.getNextEntry();
        if (entry != null && (entityType = this.parseEntityType(path = entry.getName())) != null) {
            switch (entityType) {
                case ArtifactRule: {
                    return this.readArtifactRule(entry);
                }
                case ArtifactVersion: {
                    return this.readArtifactVersion(entry);
                }
                case Content: {
                    return this.readContent(entry);
                }
                case GlobalRule: {
                    return this.readGlobalRule(entry);
                }
                case Group: {
                    return this.readGroup(entry);
                }
                case Comment: {
                    return this.readComment(entry);
                }
                case Manifest: {
                    return this.readManifest(entry);
                }
            }
        }
        return null;
    }

    private ContentEntity readContent(ZipEntry entry) throws IOException {
        if (entry.getName().endsWith(".json")) {
            ContentEntity entity = this.readEntry(entry, ContentEntity.class);
            ZipEntry dataEntry = this.zip.getNextEntry();
            if (!dataEntry.getName().endsWith(".Content.data")) {
                // empty if block
            }
            entity.contentBytes = IoUtil.toBytes((InputStream)this.zip, (boolean)false);
            this.zip.read(entity.contentBytes);
            return entity;
        }
        throw new IOException("Not yet supported: found .Content.data file before .Content.json");
    }

    private ManifestEntity readManifest(ZipEntry entry) throws IOException {
        return this.readEntry(entry, ManifestEntity.class);
    }

    private GroupEntity readGroup(ZipEntry entry) throws IOException {
        return this.readEntry(entry, GroupEntity.class);
    }

    private ArtifactVersionEntity readArtifactVersion(ZipEntry entry) throws IOException {
        return this.readEntry(entry, ArtifactVersionEntity.class);
    }

    private ArtifactRuleEntity readArtifactRule(ZipEntry entry) throws IOException {
        return this.readEntry(entry, ArtifactRuleEntity.class);
    }

    private CommentEntity readComment(ZipEntry entry) throws IOException {
        return this.readEntry(entry, CommentEntity.class);
    }

    private GlobalRuleEntity readGlobalRule(ZipEntry entry) throws IOException {
        return this.readEntry(entry, GlobalRuleEntity.class);
    }

    private EntityType parseEntityType(String path) {
        String[] split = path.split("\\.");
        if (split.length > 2) {
            String typeStr = split[split.length - 2];
            EntityType type = EntityType.valueOf(typeStr);
            return type;
        }
        return null;
    }

    private <T> T readEntry(ZipEntry entry, Class<T> theClass) throws IOException {
        byte[] bytes = IoUtil.toBytes((InputStream)this.zip, (boolean)false);
        Object entity = mapper.readerFor(theClass).readValue(bytes);
        return (T)entity;
    }

    static {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        mapper = new ObjectMapper(jsonFactory);
    }
}

