/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.stream.ChunkedFile;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.WebSocketFrameType;
import io.vertx.core.http.impl.AssembledHttpResponse;
import io.vertx.core.http.impl.WebSocketImplBase;
import io.vertx.core.http.impl.ws.WebSocketFrameImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;

abstract class Http1xConnectionBase<S extends WebSocketImplBase<S>>
extends ConnectionBase
implements HttpConnection {
    protected S webSocket;

    Http1xConnectionBase(ContextInternal context, ChannelHandlerContext chctx) {
        super(context, chctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWsFrame(WebSocketFrame msg) {
        S w;
        WebSocketFrameInternal frame = this.decodeFrame(msg);
        Http1xConnectionBase http1xConnectionBase = this;
        synchronized (http1xConnectionBase) {
            w = this.webSocket;
        }
        if (w != null) {
            ((WebSocketImplBase)w).context.execute((Object)frame, arg_0 -> w.handleFrame(arg_0));
        }
    }

    private WebSocketFrameInternal decodeFrame(WebSocketFrame msg) {
        WebSocketFrameType frameType;
        ByteBuf payload = VertxHandler.safeBuffer(msg.content());
        boolean isFinal = msg.isFinalFragment();
        if (msg instanceof BinaryWebSocketFrame) {
            frameType = WebSocketFrameType.BINARY;
        } else if (msg instanceof CloseWebSocketFrame) {
            frameType = WebSocketFrameType.CLOSE;
        } else if (msg instanceof PingWebSocketFrame) {
            frameType = WebSocketFrameType.PING;
        } else if (msg instanceof PongWebSocketFrame) {
            frameType = WebSocketFrameType.PONG;
        } else if (msg instanceof TextWebSocketFrame) {
            frameType = WebSocketFrameType.TEXT;
        } else if (msg instanceof ContinuationWebSocketFrame) {
            frameType = WebSocketFrameType.CONTINUATION;
        } else {
            throw new IllegalStateException("Unsupported WebSocket msg " + msg);
        }
        return new WebSocketFrameImpl(frameType, payload, isFinal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close() {
        S sock;
        Http1xConnectionBase http1xConnectionBase = this;
        synchronized (http1xConnectionBase) {
            sock = this.webSocket;
        }
        if (sock == null) {
            return super.close();
        }
        ((WebSocketImplBase)sock).close();
        return this.closeFuture();
    }

    @Override
    public Http1xConnectionBase closeHandler(Handler<Void> handler) {
        return (Http1xConnectionBase)super.closeHandler(handler);
    }

    @Override
    public Http1xConnectionBase exceptionHandler(Handler<Throwable> handler) {
        return (Http1xConnectionBase)super.exceptionHandler(handler);
    }

    @Override
    public HttpConnection goAway(long errorCode, int lastStreamId, Buffer debugData) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support GOAWAY");
    }

    @Override
    public HttpConnection shutdownHandler(@Nullable Handler<Void> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections cannot be shutdown");
    }

    @Override
    public void shutdown(long timeout, Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections cannot be shutdown");
    }

    @Override
    public Future<Void> shutdown(long timeoutMs) {
        throw new UnsupportedOperationException("HTTP/1.x connections cannot be shutdown");
    }

    @Override
    public Http2Settings settings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Future<Void> updateSettings(Http2Settings settings) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection updateSettings(Http2Settings settings, Handler<AsyncResult<Void>> completionHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public Http2Settings remoteSettings() {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support SETTINGS");
    }

    @Override
    public HttpConnection ping(Buffer data, Handler<AsyncResult<Buffer>> pongHandler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    public HttpConnection pingHandler(@Nullable Handler<Buffer> handler) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    public Future<Buffer> ping(Buffer data) {
        throw new UnsupportedOperationException("HTTP/1.x connections don't support PING");
    }

    @Override
    protected long sizeof(Object obj) {
        if (obj == Unpooled.EMPTY_BUFFER || obj == LastHttpContent.EMPTY_LAST_CONTENT) {
            return 0L;
        }
        if (obj instanceof AssembledHttpResponse) {
            return ((AssembledHttpResponse)obj).content().readableBytes();
        }
        if (obj instanceof Buffer) {
            return ((Buffer)obj).length();
        }
        if (obj instanceof ByteBuf) {
            return ((ByteBuf)obj).readableBytes();
        }
        if (obj instanceof FullHttpMessage) {
            return ((FullHttpMessage)obj).content().readableBytes();
        }
        if (obj instanceof LastHttpContent) {
            return ((LastHttpContent)obj).content().readableBytes();
        }
        if (obj instanceof HttpContent) {
            return ((HttpContent)obj).content().readableBytes();
        }
        if (obj instanceof WebSocketFrame) {
            return ((WebSocketFrame)obj).content().readableBytes();
        }
        if (obj instanceof FileRegion) {
            return ((FileRegion)obj).count();
        }
        if (obj instanceof ChunkedFile) {
            ChunkedFile file = (ChunkedFile)obj;
            return file.endOffset() - file.startOffset();
        }
        return 0L;
    }
}

