/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DuplicatedContext;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public abstract class ContextBase
implements ContextInternal {
    private static final Logger log = LoggerFactory.getLogger(ContextBase.class);
    private static final String DISABLE_TIMINGS_PROP_NAME = "vertx.disableContextTimings";
    static final boolean DISABLE_TIMINGS = Boolean.getBoolean("vertx.disableContextTimings");
    private final VertxInternal owner;
    private final JsonObject config;
    private final Deployment deployment;
    private final CloseFuture closeFuture;
    private final ClassLoader tccl;
    private final EventLoop eventLoop;
    private ConcurrentMap<Object, Object> data;
    private ConcurrentMap<Object, Object> localData;
    private volatile Handler<Throwable> exceptionHandler;
    final TaskQueue internalOrderedTasks;
    final WorkerPool internalWorkerPool;
    final WorkerPool workerPool;
    final TaskQueue orderedTasks;

    static <T> void setResultHandler(ContextInternal ctx, Future<T> fut, Handler<AsyncResult<T>> resultHandler) {
        if (resultHandler != null) {
            fut.onComplete(resultHandler);
        } else {
            fut.onFailure(arg_0 -> ((ContextInternal)ctx).reportException(arg_0));
        }
    }

    protected ContextBase(VertxInternal vertx, EventLoop eventLoop, WorkerPool internalWorkerPool, WorkerPool workerPool, Deployment deployment, CloseFuture closeFuture, ClassLoader tccl) {
        this.deployment = deployment;
        this.config = deployment != null ? deployment.config() : new JsonObject();
        this.eventLoop = eventLoop;
        this.tccl = tccl;
        this.owner = vertx;
        this.workerPool = workerPool;
        this.closeFuture = closeFuture;
        this.internalWorkerPool = internalWorkerPool;
        this.orderedTasks = new TaskQueue();
        this.internalOrderedTasks = new TaskQueue();
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public CloseFuture closeFuture() {
        return this.closeFuture;
    }

    public JsonObject config() {
        return this.config;
    }

    public EventLoop nettyEventLoop() {
        return this.eventLoop;
    }

    public VertxInternal owner() {
        return this.owner;
    }

    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action) {
        return ContextBase.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, this.internalOrderedTasks);
    }

    public <T> Future<T> executeBlockingInternal(Callable<T> action) {
        return ContextBase.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, this.internalOrderedTasks);
    }

    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action, boolean ordered) {
        return ContextBase.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, ordered ? this.internalOrderedTasks : null);
    }

    public <T> Future<T> executeBlockingInternal(Callable<T> action, boolean ordered) {
        return ContextBase.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, ordered ? this.internalOrderedTasks : null);
    }

    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        return ContextBase.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, ordered ? this.orderedTasks : null);
    }

    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return ContextBase.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, ordered ? this.orderedTasks : null);
    }

    public boolean isEventLoopContext() {
        return false;
    }

    public boolean isWorkerContext() {
        return false;
    }

    public Executor executor() {
        return null;
    }

    public boolean inThread() {
        return false;
    }

    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue) {
        return ContextBase.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, queue);
    }

    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, TaskQueue queue) {
        return ContextBase.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, queue);
    }

    static <T> Future<T> executeBlocking(ContextInternal context, Callable<T> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        return ContextBase.internalExecuteBlocking(context, promise -> {
            Object result;
            try {
                result = blockingCodeHandler.call();
            }
            catch (Throwable e) {
                promise.fail(e);
                return;
            }
            promise.complete(result);
        }, workerPool, queue);
    }

    static <T> Future<T> executeBlocking(ContextInternal context, Handler<Promise<T>> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        return ContextBase.internalExecuteBlocking(context, promise -> {
            try {
                blockingCodeHandler.handle((Promise)promise);
            }
            catch (Throwable e) {
                promise.tryFail(e);
            }
        }, workerPool, queue);
    }

    private static <T> Future<T> internalExecuteBlocking(ContextInternal context, Handler<Promise<T>> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        PoolMetrics metrics = workerPool.metrics();
        Object queueMetric = metrics != null ? (Object)metrics.submitted() : null;
        PromiseInternal promise = context.promise();
        Future fut = promise.future();
        try {
            Runnable command = () -> {
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                context.dispatch((Object)promise, blockingCodeHandler);
                if (metrics != null) {
                    metrics.end(execMetric, fut.succeeded());
                }
            };
            ExecutorService exec = workerPool.executor();
            if (queue != null) {
                queue.execute(command, exec);
            } else {
                exec.execute(command);
            }
        }
        catch (RejectedExecutionException e) {
            if (metrics != null) {
                metrics.rejected(queueMetric);
            }
            throw e;
        }
        return fut;
    }

    public VertxTracer tracer() {
        return this.owner.tracer();
    }

    public ClassLoader classLoader() {
        return this.tccl;
    }

    public WorkerPool workerPool() {
        return this.workerPool;
    }

    public synchronized ConcurrentMap<Object, Object> contextData() {
        if (this.data == null) {
            this.data = new ConcurrentHashMap<Object, Object>();
        }
        return this.data;
    }

    public synchronized ConcurrentMap<Object, Object> localContextData() {
        if (this.localData == null) {
            this.localData = new ConcurrentHashMap<Object, Object>();
        }
        return this.localData;
    }

    public void reportException(Throwable t) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler == null) {
            handler = this.owner.exceptionHandler();
        }
        if (handler != null) {
            handler.handle(t);
        } else {
            log.error("Unhandled exception", t);
        }
    }

    public Context exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    public final void runOnContext(Handler<Void> action) {
        this.runOnContext(this, action);
    }

    protected abstract void runOnContext(ContextInternal var1, Handler<Void> var2);

    public void execute(Runnable task) {
        this.execute(this, task);
    }

    protected abstract <T> void execute(ContextInternal var1, Runnable var2);

    public final <T> void execute(T argument, Handler<T> task) {
        this.execute(this, argument, task);
    }

    protected abstract <T> void execute(ContextInternal var1, T var2, Handler<T> var3);

    public <T> void emit(T argument, Handler<T> task) {
        this.emit(this, argument, task);
    }

    protected abstract <T> void emit(ContextInternal var1, T var2, Handler<T> var3);

    public ContextInternal duplicate() {
        return new DuplicatedContext(this);
    }
}

