/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.multitenancy.context;

import io.apicurio.common.apps.multitenancy.ApicurioTenantContext;
import io.apicurio.common.apps.multitenancy.MultitenancyProperties;
import io.apicurio.common.apps.multitenancy.TenantContext;
import io.apicurio.common.apps.multitenancy.TenantIdResolver;
import io.apicurio.common.apps.multitenancy.context.ApicurioTenantContextImpl;
import io.apicurio.common.apps.multitenancy.context.TenantContextLoaderImpl;
import io.apicurio.common.apps.multitenancy.limits.TenantLimitsConfiguration;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.core.http.HttpServerRequest;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import org.slf4j.MDC;

@RequestScoped
public class TenantContextImpl
implements TenantContext {
    private static final String TENANT_ID_KEY = "tenantId";
    private Optional<ApicurioTenantContext> current = Optional.empty();
    private static final ApicurioTenantContext EMPTY_CONTEXT = new ApicurioTenantContextImpl("_", null, null, TenantStatusValue.READY, null);
    private static final ThreadLocal<ApicurioTenantContext> CURRENT = ThreadLocal.withInitial(() -> EMPTY_CONTEXT);
    @Inject
    TenantContextLoaderImpl contextLoader;
    @Inject
    TenantIdResolver tenantIdResolver;
    @Inject
    CurrentVertxRequest request;
    @Inject
    MultitenancyProperties multitenancyProperties;

    @PostConstruct
    public void load() {
        ApicurioTenantContext loadedContext;
        if (this.multitenancyProperties.isMultitenancyEnabled() && this.request.getCurrent() != null) {
            HttpServerRequest req = this.request.getCurrent().request();
            String requestURI = req.uri();
            Optional<String> tenantIdOpt = this.tenantIdResolver.resolveTenantId(requestURI, arg_0 -> ((HttpServerRequest)req).getHeader(arg_0), () -> ((HttpServerRequest)req).host(), null);
            loadedContext = tenantIdOpt.map(tenantId -> this.contextLoader.loadRequestContext((String)tenantId)).orElse(this.contextLoader.defaultTenantContext());
        } else {
            loadedContext = this.contextLoader.defaultTenantContext();
        }
        this.setContext(loadedContext);
    }

    public String tenantId() {
        return this.current.map(ApicurioTenantContext::getTenantId).orElse(CURRENT.get().getTenantId());
    }

    public ApicurioTenantContext currentContext() {
        return this.current.orElse(CURRENT.get());
    }

    public String tenantOwner() {
        return this.current.map(ApicurioTenantContext::getTenantOwner).orElse(CURRENT.get().getTenantOwner());
    }

    public TenantLimitsConfiguration limitsConfig() {
        return this.current.map(ApicurioTenantContext::getLimitsConfiguration).orElse(CURRENT.get().getLimitsConfiguration());
    }

    public void setContext(ApicurioTenantContext ctx) {
        this.current = Optional.of(ctx);
        MDC.put((String)TENANT_ID_KEY, (String)ctx.getTenantId());
    }

    public void clearContext() {
        this.current = Optional.of(EMPTY_CONTEXT);
        MDC.remove((String)TENANT_ID_KEY);
    }

    public boolean isLoaded() {
        return !this.tenantId().equals("_");
    }

    public TenantStatusValue getTenantStatus() {
        return this.current.map(ApicurioTenantContext::getStatus).orElse(CURRENT.get().getStatus());
    }
}

