/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.auth.authn;

import io.apicurio.common.apps.auth.authn.CredentialsHelper;
import io.apicurio.common.apps.auth.authn.WrappedValue;
import io.apicurio.common.apps.config.Dynamic;
import io.apicurio.common.apps.config.Info;
import io.apicurio.common.apps.logging.audit.AuditHttpRequestInfo;
import io.apicurio.common.apps.logging.audit.AuditLogService;
import io.apicurio.common.apps.util.Pair;
import io.apicurio.rest.client.VertxHttpClientProvider;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.auth.exception.AuthException;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.apicurio.rest.client.error.ApicurioRestClientException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.quarkus.oidc.runtime.BearerAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcAuthenticationMechanism;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.slf4j.Logger;

@Alternative
@Priority(value=1)
@ApplicationScoped
public class AppAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @ConfigProperty(name="app.authn.enabled", defaultValue="false")
    @Info(category="auth", description="Enable auth", availableSince="0.1.18-SNAPSHOT", registryAvailableSince="2.0.0.Final")
    boolean authEnabled;
    @Dynamic(label="HTTP basic authentication", description="When selected, users are permitted to authenticate using HTTP basic authentication (in addition to OAuth).", requires={"app.authn.enabled=true"})
    @ConfigProperty(name="app.authn.basic-auth-client-credentials.enabled", defaultValue="false")
    @Info(category="auth", description="Enable basic auth client credentials", availableSince="0.1.18-SNAPSHOT", registryAvailableSince="2.1.0.Final")
    Supplier<Boolean> fakeBasicAuthEnabled;
    @ConfigProperty(name="app.authn.basic-auth-client-credentials.cache-expiration", defaultValue="10")
    @Info(category="auth", description="Client credentials token expiration time.", availableSince="0.1.18-SNAPSHOT", registryAvailableSince="2.2.6.Final")
    Integer accessTokenExpiration;
    @ConfigProperty(name="app.authn.basic-auth.scope")
    @Info(category="auth", description="Client credentials scope.", availableSince="0.1.21-SNAPSHOT", registryAvailableSince="2.5.0.Final")
    Optional<String> scope;
    @ConfigProperty(name="app.authn.audit.log.prefix", defaultValue="audit")
    @Info(category="auth", description="Prefix used for application audit logging.", availableSince="0.1.18-SNAPSHOT", registryAvailableSince="2.2.6")
    String auditLogPrefix;
    @ConfigProperty(name="app.authn.token.endpoint", defaultValue="")
    @Info(category="auth", description="Authentication server url.", availableSince="0.1.18-SNAPSHOT", registryAvailableSince="2.1.0.Final")
    String authServerUrl;
    @ConfigProperty(name="app.authn.client-secret")
    @Info(category="auth", description="Client secret used by the server for authentication.", availableSince="0.1.18-SNAPSHOT", registryAvailableSince="2.1.0.Final")
    Optional<String> clientSecret;
    @ConfigProperty(name="app.authn.client-id", defaultValue="")
    @Info(category="auth", description="Client identifier used by the server for authentication.", availableSince="0.1.18-SNAPSHOT", registryAvailableSince="2.0.0.Final")
    String clientId;
    @Inject
    OidcAuthenticationMechanism oidcAuthenticationMechanism;
    @Inject
    AuditLogService auditLog;
    @Inject
    Logger log;
    @Inject
    Vertx vertx;
    private BearerAuthenticationMechanism bearerAuth;
    private ApicurioHttpClient httpClient;
    private ConcurrentHashMap<String, WrappedValue<String>> cachedAccessTokens;
    private ConcurrentHashMap<String, WrappedValue<ApicurioRestClientException>> cachedAuthFailures;

    @PostConstruct
    public void init() {
        if (this.authEnabled) {
            this.cachedAccessTokens = new ConcurrentHashMap();
            this.cachedAuthFailures = new ConcurrentHashMap();
            this.httpClient = new VertxHttpClientProvider(this.vertx).create(this.authServerUrl, Collections.emptyMap(), null, (RestClientErrorHandler)new AuthErrorHandler());
            this.bearerAuth = new BearerAuthenticationMechanism();
        }
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        if (this.authEnabled) {
            this.setAuditLogger(context);
            if (this.fakeBasicAuthEnabled.get().booleanValue()) {
                Pair<String, String> clientCredentials = CredentialsHelper.extractCredentialsFromContext(context);
                if (null != clientCredentials) {
                    try {
                        return this.authenticateWithClientCredentials(clientCredentials, context, identityProviderManager);
                    }
                    catch (AuthException | NotAuthorizedException ex) {
                        this.log.warn(String.format("Exception trying to get an access token with client credentials with client id: %s", clientCredentials.getLeft()), ex);
                        return this.oidcAuthenticationMechanism.authenticate(context, identityProviderManager);
                    }
                }
                return this.customAuthentication(context, identityProviderManager);
            }
            return this.customAuthentication(context, identityProviderManager);
        }
        return Uni.createFrom().nullItem();
    }

    public Uni<SecurityIdentity> customAuthentication(RoutingContext context, IdentityProviderManager identityProviderManager) {
        if (this.clientSecret.isEmpty()) {
            return this.oidcAuthenticationMechanism.authenticate(context, identityProviderManager);
        }
        Pair<String, String> credentialsFromContext = CredentialsHelper.extractCredentialsFromContext(context);
        if (credentialsFromContext != null) {
            OidcAuth oidcAuth = new OidcAuth(this.httpClient, this.clientId, this.clientSecret.get());
            String jwtToken = oidcAuth.obtainAccessTokenPasswordGrant((String)credentialsFromContext.getLeft(), (String)credentialsFromContext.getRight());
            if (jwtToken != null) {
                context.request().headers().set("Authorization", "Bearer " + jwtToken);
                return this.oidcAuthenticationMechanism.authenticate(context, identityProviderManager);
            }
        } else {
            return this.oidcAuthenticationMechanism.authenticate(context, identityProviderManager);
        }
        return Uni.createFrom().nullItem();
    }

    private void setAuditLogger(RoutingContext context) {
        BiConsumer failureHandler = (BiConsumer)context.get("io.quarkus.vertx.http.auth-failure-handler");
        BiConsumer<RoutingContext, Throwable> auditWrapper = (ctx, ex) -> {
            failureHandler.accept(ctx, ex);
            if (ctx.response().getStatusCode() >= 400) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("method", ctx.request().method().name());
                metadata.put("path", ctx.request().path());
                metadata.put("response_code", String.valueOf(ctx.response().getStatusCode()));
                if (ex != null) {
                    metadata.put("error_msg", ex.getMessage());
                }
                this.auditLog.log(this.auditLogPrefix, "authenticate", "failure", metadata, new AuditHttpRequestInfo((RoutingContext)ctx){
                    final /* synthetic */ RoutingContext val$ctx;
                    {
                        this.val$ctx = routingContext;
                    }

                    public String getSourceIp() {
                        return this.val$ctx.request().remoteAddress().toString();
                    }

                    public String getForwardedFor() {
                        return this.val$ctx.request().getHeader("x-forwarded-for");
                    }
                });
            }
        };
        context.put("io.quarkus.vertx.http.auth-failure-handler", auditWrapper);
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return this.bearerAuth.getChallenge(context);
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public HttpCredentialTransport getCredentialTransport() {
        return new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, "bearer");
    }

    private Uni<SecurityIdentity> authenticateWithClientCredentials(Pair<String, String> clientCredentials, RoutingContext context, IdentityProviderManager identityProviderManager) {
        String credentialsHash = this.getCredentialsHash((String)clientCredentials.getLeft() + (String)clientCredentials.getRight());
        if (this.authFailureIsCached(credentialsHash)) {
            throw this.cachedAuthFailures.get(credentialsHash).getValue();
        }
        String jwtToken = this.accessTokenIsCached(credentialsHash) ? this.cachedAccessTokens.get(credentialsHash).getValue() : this.getAccessToken(clientCredentials, credentialsHash);
        context.request().headers().set("Authorization", "Bearer " + jwtToken);
        return this.oidcAuthenticationMechanism.authenticate(context, identityProviderManager);
    }

    private boolean authFailureIsCached(String credentialsHash) {
        return this.cachedAuthFailures.containsKey(credentialsHash) && !this.cachedAuthFailures.get(credentialsHash).isExpired();
    }

    private boolean accessTokenIsCached(String credentialsHash) {
        return this.cachedAccessTokens.containsKey(credentialsHash) && !this.cachedAccessTokens.get(credentialsHash).isExpired();
    }

    @Retry(retryOn={AuthException.class}, maxRetries=4, delay=1L, delayUnit=ChronoUnit.SECONDS)
    public String getAccessToken(Pair<String, String> clientCredentials, String credentialsHash) {
        OidcAuth oidcAuth = new OidcAuth(this.httpClient, (String)clientCredentials.getLeft(), (String)clientCredentials.getRight(), Duration.ofSeconds(1L), (String)this.scope.orElse(null));
        try {
            String jwtToken = oidcAuth.authenticate();
            this.cachedAccessTokens.put(credentialsHash, new WrappedValue<String>(Duration.ofMinutes(this.accessTokenExpiration.intValue()), Instant.now(), jwtToken));
            return jwtToken;
        }
        catch (ForbiddenException | NotAuthorizedException ex) {
            this.cachedAuthFailures.put(credentialsHash, new WrappedValue<Throwable>(Duration.ofMinutes(this.accessTokenExpiration.intValue()), Instant.now(), ex));
            throw ex;
        }
    }

    private String getCredentialsHash(String credentials) {
        return DigestUtils.sha256Hex((String)credentials);
    }
}

