/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.kafka;

import java.util.Collections;
import java.util.function.BiConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Seek {
    FROM_BEGINNING,
    FROM_END,
    FROM_CURRENT,
    TO_ABSOLUTE;

    static final Logger log;

    public Offset offset(long offset) {
        return new Offset(offset);
    }

    static {
        log = LoggerFactory.getLogger(Seek.class);
    }

    public final class Offset
    implements BiConsumer<Consumer<?, ?>, TopicPartition> {
        private final long offset;

        Offset(long offset) {
            this.offset = offset;
        }

        public long offset() {
            return this.offset;
        }

        public Seek seek() {
            return Seek.this;
        }

        @Override
        public void accept(Consumer<?, ?> consumer, TopicPartition topicPartition) {
            Long absOffset = null;
            switch (this.seek()) {
                case FROM_BEGINNING: {
                    consumer.seekToBeginning(Collections.singletonList(topicPartition));
                    log.info("seekToBeginning: {}", (Object)topicPartition);
                    if (this.offset == 0L) break;
                    absOffset = Math.max(0L, consumer.position(topicPartition) + this.offset);
                    break;
                }
                case FROM_END: {
                    consumer.seekToEnd(Collections.singletonList(topicPartition));
                    log.info("seekToEnd: {}", (Object)topicPartition);
                    if (this.offset == 0L) break;
                    absOffset = Math.max(0L, consumer.position(topicPartition) + this.offset);
                    break;
                }
                case FROM_CURRENT: {
                    if (this.offset == 0L) break;
                    absOffset = Math.max(0L, consumer.position(topicPartition) + this.offset);
                    break;
                }
                case TO_ABSOLUTE: {
                    absOffset = this.offset;
                }
            }
            if (absOffset != null) {
                log.info("seek: {} to offset: {}", (Object)topicPartition, (Object)absOffset);
                consumer.seek(topicPartition, absOffset.longValue());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Offset offset1 = (Offset)o;
            return this.seek() == offset1.seek() && this.offset == offset1.offset;
        }

        public int hashCode() {
            return this.seek().hashCode() * 31 + Long.hashCode(this.offset);
        }

        public String toString() {
            return "Seek." + (Object)((Object)this.seek()) + ".offset(" + this.offset + ")";
        }
    }
}

