/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.kafka;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.apicurio.registry.utils.kafka.SelfSerde;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public class ProtoSerde<M extends MessageLite>
extends SelfSerde<M> {
    private final Parser<M> parser;

    public static <M extends MessageLite> ProtoSerde<M> parsedWith(Parser<M> parser) {
        return new ProtoSerde<M>(parser);
    }

    protected ProtoSerde(Parser<M> parser) {
        this.parser = Objects.requireNonNull(parser);
    }

    public M deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (M)((MessageLite)this.parser.parseFrom(data));
        }
        catch (InvalidProtocolBufferException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public byte[] serialize(String topic, M message) {
        return message == null ? null : message.toByteArray();
    }
}

