/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.utils.serde.AbstractKafkaSerDe;
import io.apicurio.registry.utils.serde.strategy.ArtifactIdStrategy;
import io.apicurio.registry.utils.serde.strategy.FindBySchemaIdStrategy;
import io.apicurio.registry.utils.serde.strategy.GlobalIdStrategy;
import io.apicurio.registry.utils.serde.strategy.TopicIdStrategy;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractKafkaStrategyAwareSerDe<T, S extends AbstractKafkaStrategyAwareSerDe<T, S>>
extends AbstractKafkaSerDe<S> {
    public static final String REGISTRY_ARTIFACT_ID_STRATEGY_CONFIG_PARAM = "apicurio.registry.artifact-id";
    public static final String REGISTRY_GLOBAL_ID_STRATEGY_CONFIG_PARAM = "apicurio.registry.global-id";
    private ArtifactIdStrategy<T> artifactIdStrategy;
    private GlobalIdStrategy<T> globalIdStrategy;
    private boolean key;

    public AbstractKafkaStrategyAwareSerDe() {
        this(null);
    }

    public AbstractKafkaStrategyAwareSerDe(RegistryService client) {
        this(client, new TopicIdStrategy(), new FindBySchemaIdStrategy());
    }

    public AbstractKafkaStrategyAwareSerDe(RegistryService client, ArtifactIdStrategy<T> artifactIdStrategy, GlobalIdStrategy<T> globalIdStrategy) {
        super(client);
        this.setArtifactIdStrategy(artifactIdStrategy);
        this.setGlobalIdStrategy(globalIdStrategy);
    }

    protected ArtifactIdStrategy<T> getArtifactIdStrategy() {
        return this.artifactIdStrategy;
    }

    protected GlobalIdStrategy<T> getGlobalIdStrategy() {
        return this.globalIdStrategy;
    }

    protected boolean isKey() {
        return this.key;
    }

    public S setKey(boolean key) {
        this.key = key;
        return (S)((AbstractKafkaStrategyAwareSerDe)this.self());
    }

    public S setArtifactIdStrategy(ArtifactIdStrategy<T> artifactIdStrategy) {
        this.artifactIdStrategy = Objects.requireNonNull(artifactIdStrategy);
        return (S)((AbstractKafkaStrategyAwareSerDe)this.self());
    }

    public S setGlobalIdStrategy(GlobalIdStrategy<T> globalIdStrategy) {
        this.globalIdStrategy = Objects.requireNonNull(globalIdStrategy);
        return (S)((AbstractKafkaStrategyAwareSerDe)this.self());
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(configs);
        Object ais = configs.get(REGISTRY_ARTIFACT_ID_STRATEGY_CONFIG_PARAM);
        this.instantiate(ArtifactIdStrategy.class, ais, this::setArtifactIdStrategy);
        Object gis = configs.get(REGISTRY_GLOBAL_ID_STRATEGY_CONFIG_PARAM);
        this.instantiate(GlobalIdStrategy.class, gis, this::setGlobalIdStrategy);
        this.key = isKey;
    }
}

